/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler.gallery;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import thebetweenlands.client.handler.gallery.GalleryEntry;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;

public final class GalleryManager {
    private static final ExecutorService DOWNLOADER = Executors.newFixedThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("BL Gallery Downloader #" + GALLERY_DOWNLOADER_THREAD_ID.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final AtomicInteger GALLERY_DOWNLOADER_THREAD_ID = new AtomicInteger(0);
    public static final Gson GSON = new Gson();
    public static final Type STRING_ARRAY_TYPE = new TypeToken<String[]>(){}.getType();
    public static final GalleryManager INSTANCE = new GalleryManager();
    private Map<String, GalleryEntry> entries = new HashMap<String, GalleryEntry>();

    private GalleryManager() {
    }

    public Map<String, GalleryEntry> getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadLocalIndex(File folder) {
        File file = new File(folder, "index.json");
        if (file.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                JsonParser parser = new JsonParser();
                JsonElement json = parser.parse((Reader)reader);
                Map<String, GalleryEntry> map = this.entries;
                synchronized (map) {
                    this.entries = this.parseLocalIndex(folder, json);
                }
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error("Failed loading local gallery index", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveLocalIndex(File folder) {
        File file = new File(folder, "index.json");
        file.delete();
        try (FileWriter fileWriter = new FileWriter(file);){
            JsonArray indexArr = new JsonArray();
            Map<String, GalleryEntry> map = this.entries;
            synchronized (map) {
                for (GalleryEntry entry : this.entries.values()) {
                    indexArr.add((JsonElement)this.writeEntry(entry));
                }
            }
            GSON.toJson((JsonElement)indexArr, (Appendable)fileWriter);
        }
        catch (IOException e) {
            TheBetweenlands.logger.error("Failed saving local gallery index", (Throwable)e);
        }
    }

    public void checkAndUpdate(final File folder) {
        this.loadLocalIndex(folder);
        if (BetweenlandsConfig.GENERAL.onlineGallery) {
            final Proxy proxy = TheBetweenlands.proxy.getNetProxy();
            DOWNLOADER.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TheBetweenlands.logger.info("Updating gallery");
                        URL url = new URL("https://raw.githubusercontent.com/Angry-Pixel/The-Betweenlands/online_picture_gallery/index.json");
                        HttpURLConnection request = null;
                        try {
                            request = GalleryManager.this.createHttpConnection(url, proxy);
                            request.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                            request.connect();
                            if (request.getResponseCode() == 200) {
                                JsonParser parser = new JsonParser();
                                JsonElement jsonElement = parser.parse((Reader)new InputStreamReader(request.getInputStream(), StandardCharsets.UTF_8));
                                GalleryManager.this.updateLocalIndexFromOnline(folder, jsonElement, proxy);
                            }
                        }
                        finally {
                            if (request != null) {
                                request.disconnect();
                            }
                        }
                    }
                    catch (Exception ex) {
                        TheBetweenlands.logger.error("Failed downloading gallery data", (Throwable)ex);
                    }
                }
            });
        }
    }

    private HttpURLConnection createHttpConnection(URL url, @Nullable Proxy proxy) throws IOException {
        HttpURLConnection request = null;
        request = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        request.setDoInput(true);
        request.setDoOutput(false);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLocalIndexFromOnline(File folder, JsonElement json, @Nullable Proxy proxy) {
        Map<String, GalleryEntry> onlineEntries = this.parseOnlineIndex(folder, json);
        HashMap<String, GalleryEntry> newLocalEntries = new HashMap<String, GalleryEntry>();
        boolean changed = false;
        HashMap<String, GalleryEntry> localEntriesCopy = new HashMap<String, GalleryEntry>();
        Object object = this.entries;
        synchronized (object) {
            localEntriesCopy.putAll(this.entries);
        }
        for (GalleryEntry localEntry : localEntriesCopy.values()) {
            GalleryEntry onlineEntry = onlineEntries.get(localEntry.getUrl());
            String localSha256 = localEntry.getLocalSha256();
            if (onlineEntry == null) {
                newLocalEntries.put(localEntry.getUrl(), localEntry);
                continue;
            }
            if (localSha256 == null || !localSha256.equals(onlineEntry.getSha256())) {
                TheBetweenlands.logger.info("Removing gallery entry '" + localEntry.getSha256() + "'/'" + localEntry.getUrl() + "' because the local hash (" + localSha256 + ") does not match");
                this.deleteLocalPicture(folder, localEntry);
                changed = true;
                continue;
            }
            newLocalEntries.put(onlineEntry.getUrl(), onlineEntry);
        }
        for (GalleryEntry onlineEntry : onlineEntries.values()) {
            if (newLocalEntries.containsKey(onlineEntry.getUrl())) continue;
            try {
                if (this.downloadPicture(folder, onlineEntry, proxy)) {
                    String localSha256 = onlineEntry.getLocalSha256();
                    if (localSha256 != null && !onlineEntry.getSha256().equals(localSha256)) {
                        TheBetweenlands.logger.info("Downloaded gallery picture '" + onlineEntry.getUrl() + "' SHA256 hash does not match (Expected: " + onlineEntry.getSha256() + " Got: " + localSha256 + ")! Please report this to the mod authors.");
                    }
                    newLocalEntries.put(onlineEntry.getUrl(), onlineEntry);
                    changed = true;
                    continue;
                }
                TheBetweenlands.logger.error("Failed downloading gallery picture '" + onlineEntry.getUrl() + "'");
            }
            catch (Exception ex) {
                TheBetweenlands.logger.error("Failed downloading gallery picture '" + onlineEntry.getUrl() + "'", (Throwable)ex);
            }
        }
        object = this.entries;
        synchronized (object) {
            this.entries = newLocalEntries;
        }
        if (changed) {
            this.saveLocalIndex(folder);
        }
    }

    private File getPictureFile(File folder, GalleryEntry entry) {
        return this.getPictureFile(folder, entry.getSha256());
    }

    private File getPictureFile(File folder, String sha256) {
        return new File(folder, sha256.toLowerCase() + ".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadPicture(File folder, GalleryEntry entry, @Nullable Proxy proxy) throws IOException {
        TheBetweenlands.logger.info("Downloading gallery picture '" + entry.getSha256() + "'/'" + entry.getUrl() + "'");
        URL url = new URL(entry.getUrl());
        HttpURLConnection request = null;
        try {
            request = this.createHttpConnection(url, proxy);
            request.connect();
            if (request.getResponseCode() == 200) {
                Files.copy(request.getInputStream(), this.getPictureFile(folder, entry).toPath(), StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (request != null) {
                request.disconnect();
            }
        }
        return false;
    }

    private void deleteLocalPicture(File folder, GalleryEntry entry) {
        try {
            File file = this.getPictureFile(folder, entry);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception ex) {
            TheBetweenlands.logger.error("Failed deleting gallery picture", (Throwable)ex);
        }
    }

    private Map<String, GalleryEntry> parseLocalIndex(File folder, JsonElement json) {
        HashMap<String, GalleryEntry> entries = new HashMap<String, GalleryEntry>();
        if (json.isJsonArray()) {
            JsonArray index = json.getAsJsonArray();
            for (int j = 0; j < index.size(); ++j) {
                try {
                    JsonObject entryJson = index.get(j).getAsJsonObject();
                    GalleryEntry entry = this.parseEntry(folder, entryJson);
                    entries.put(entry.getUrl(), entry);
                    continue;
                }
                catch (Exception ex) {
                    if (!BetweenlandsConfig.DEBUG.debug) continue;
                    TheBetweenlands.logger.error("Failed parsing local gallery index entry: " + j, (Throwable)ex);
                }
            }
        }
        return entries;
    }

    private Map<String, GalleryEntry> parseOnlineIndex(File folder, JsonElement json) {
        HashMap<String, GalleryEntry> entries = new HashMap<String, GalleryEntry>();
        if (json.isJsonArray()) {
            JsonArray jsonArr = json.getAsJsonArray();
            for (int i = 0; i < jsonArr.size(); ++i) {
                try {
                    boolean isVersionValid;
                    JsonObject element = jsonArr.get(i).getAsJsonObject();
                    if (element.has("versions")) {
                        String[] versions;
                        isVersionValid = false;
                        for (String version : versions = (String[])GSON.fromJson(element.get("versions"), STRING_ARRAY_TYPE)) {
                            if (!"1.0.0".equals(version)) continue;
                            isVersionValid = true;
                            break;
                        }
                    } else {
                        isVersionValid = true;
                    }
                    if (!isVersionValid) continue;
                    JsonArray index = element.get("index").getAsJsonArray();
                    for (int j = 0; j < index.size(); ++j) {
                        try {
                            JsonObject entryJson = index.get(j).getAsJsonObject();
                            GalleryEntry entry = this.parseEntry(folder, entryJson);
                            entries.put(entry.getUrl(), entry);
                            continue;
                        }
                        catch (Exception ex) {
                            if (!BetweenlandsConfig.DEBUG.debug) continue;
                            TheBetweenlands.logger.error("Failed parsing gallery index entry: " + j, (Throwable)ex);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    if (!BetweenlandsConfig.DEBUG.debug) continue;
                    TheBetweenlands.logger.error("Failed parsing gallery version entry: " + i, (Throwable)ex);
                }
            }
        }
        return entries;
    }

    private JsonObject writeEntry(GalleryEntry entry) {
        JsonObject json = new JsonObject();
        json.add("sha256", (JsonElement)new JsonPrimitive(entry.getSha256()));
        json.add("url", (JsonElement)new JsonPrimitive(entry.getUrl()));
        json.add("title", (JsonElement)new JsonPrimitive(entry.getTitle()));
        json.add("author", (JsonElement)new JsonPrimitive(entry.getAuthor()));
        if (entry.getDescription() != null) {
            json.add("description", (JsonElement)new JsonPrimitive(entry.getDescription()));
        }
        if (entry.getSourceUrl() != null) {
            json.add("source_url", (JsonElement)new JsonPrimitive(entry.getSourceUrl()));
        }
        return json;
    }

    private GalleryEntry parseEntry(File folder, JsonObject json) {
        String sha256 = JsonUtils.func_151200_h((JsonObject)json, (String)"sha256");
        String url = JsonUtils.func_151200_h((JsonObject)json, (String)"url");
        String title = JsonUtils.func_151200_h((JsonObject)json, (String)"title");
        String author = JsonUtils.func_151200_h((JsonObject)json, (String)"author");
        String description = json.has("description") ? JsonUtils.func_151200_h((JsonObject)json, (String)"description") : null;
        String sourceUrl = json.has("source_url") ? JsonUtils.func_151200_h((JsonObject)json, (String)"source_url") : null;
        return new GalleryEntry(sha256, url, title, author, description, sourceUrl, this.getPictureFile(folder, sha256));
    }
}

