/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler.equipment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thebetweenlands.api.capability.IEquipmentCapability;
import thebetweenlands.api.event.EquipmentChangedEvent;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.client.handler.equipment.Categories;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.equipment.EnumEquipmentInventory;
import thebetweenlands.common.capability.equipment.EquipmentHelper;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.registries.KeyBindRegistry;
import thebetweenlands.util.GuiUtils;

public class RadialMenuHandler {
    public static final RadialMenuHandler INSTANCE = new RadialMenuHandler();
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands", "textures/gui/radial_menu.png");
    private boolean isOpen = false;
    private boolean repositionMouse = false;
    private int prevMouseX;
    private int prevMouseY;
    private boolean[] mouseButtons;
    private boolean scheduleMenuUpdate = false;
    private Category rootCategory = new Category("Root", 0x30101010, 0x30101010);
    private Category currentCategory;
    private List<Category> lastCategories = new ArrayList<Category>();
    private int radius = 50;
    private int innerRadius = 15;
    private int guiX;
    private int guiY;
    private int displayedCategories = 0;
    private List<ItemStack> equippables = new ArrayList<ItemStack>();

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (KeyBindRegistry.RADIAL_MENU.func_151468_f()) {
            KeyBinding.func_74510_a((int)KeyBindRegistry.RADIAL_MENU.func_151463_i(), (boolean)false);
            if (!this.isOpen) {
                this.openGUI();
            } else {
                this.closeGUI();
            }
        }
    }

    @SubscribeEvent
    public void onMouseInput(MouseEvent event) {
        if (this.isOpen) {
            event.setCanceled(true);
            if (Minecraft.func_71410_x().field_71415_G) {
                Minecraft.func_71410_x().field_71417_B.func_74373_b();
                Minecraft.func_71410_x().field_71415_G = false;
                this.repositionMouse = true;
            }
            if (this.mouseButtons == null || this.mouseButtons.length < Mouse.getButtonCount()) {
                this.mouseButtons = new boolean[Mouse.getButtonCount()];
            }
            ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
            double mouseX = this.prevMouseX * res.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
            double mouseY = res.func_78328_b() - this.prevMouseY * res.func_78328_b() / Minecraft.func_71410_x().field_71440_d;
            for (int i = 0; i < Mouse.getButtonCount(); ++i) {
                if (Mouse.isButtonDown((int)i)) {
                    if (this.mouseButtons[i]) continue;
                    this.mouseButtons[i] = true;
                    this.onMouseClick((int)mouseX, (int)mouseY, i);
                    continue;
                }
                this.mouseButtons[i] = false;
            }
        }
    }

    public void openGUI() {
        this.isOpen = true;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        Minecraft.func_71410_x().field_71417_B.func_74373_b();
        Minecraft.func_71410_x().field_71415_G = false;
        this.prevMouseX = Mouse.getX();
        this.prevMouseY = Mouse.getY();
        this.updateMenu();
    }

    public void closeGUI() {
        this.isOpen = false;
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        Minecraft.func_71410_x().func_71381_h();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void scheduleMenuUpdate() {
        this.scheduleMenuUpdate = true;
    }

    public void updateMenu() {
        int prevIndex = this.currentCategory != null ? this.currentCategory.index : 0;
        this.rootCategory.categories.clear();
        this.currentCategory = this.rootCategory;
        this.lastCategories.clear();
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player != null) {
            InventoryPlayer inventory = player.field_71071_by;
            ArrayList<Categories.EquipCategory> categories = new ArrayList<Categories.EquipCategory>();
            IEquipmentCapability cap = (IEquipmentCapability)player.getCapability(CapabilityRegistry.CAPABILITY_EQUIPMENT, null);
            if (cap != null) {
                for (EnumEquipmentInventory type : EnumEquipmentInventory.VALUES) {
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack res;
                        IEquippable equippable;
                        ItemStack stack = inventory.func_70301_a(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable) || (equippable = (IEquippable)stack.func_77973_b()).getEquipmentCategory(stack) != type || !equippable.canEquip(stack, player, (Entity)player) || !(res = EquipmentHelper.equipItem(player, (Entity)player, stack, true)).func_190926_b() && res.func_190916_E() == stack.func_190916_E()) continue;
                        categories.add(new Categories.EquipCategory(I18n.func_135052_a((String)"equipment.menu.equip", (Object[])new Object[]{stack.func_82833_r()}), 1611704848, -586110448, stack, type, i));
                    }
                }
                for (EnumEquipmentInventory type : EnumEquipmentInventory.VALUES) {
                    IInventory inv = cap.getInventory(type);
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        ItemStack stack = inv.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() instanceof IEquippable && !((IEquippable)stack.func_77973_b()).canUnequip(stack, player, (Entity)player, inv)) continue;
                        categories.add(new Categories.UnequipCategory(I18n.func_135052_a((String)"equipment.menu.unequip", (Object[])new Object[]{stack.func_82833_r()}), 1621757968, -576057328, stack, type, i));
                    }
                }
            }
            int index = 0;
            int page = 1;
            int categoryLimit = 10;
            Category currentCategory = this.rootCategory;
            ArrayList<Category> pages = new ArrayList<Category>();
            for (Category category : categories) {
                if (currentCategory.getCategories().size() > categoryLimit) {
                    Category newPage = new Category(I18n.func_135052_a((String)"equipment.menu.page", (Object[])new Object[]{++page}), -2146430960, -299884512);
                    currentCategory.addCategory(newPage);
                    currentCategory = newPage;
                    pages.add(newPage);
                }
                currentCategory.addCategory(category);
            }
            ArrayList<Category> allCategories = new ArrayList<Category>();
            allCategories.addAll(categories);
            allCategories.addAll(pages);
            for (Category category : allCategories) {
                category.index = ++index;
            }
            for (Category category : allCategories) {
                if (category.index != prevIndex || category.getCategories().isEmpty()) continue;
                Category parent = category;
                while ((parent = parent.parent) != null) {
                    this.lastCategories.add(parent);
                }
                Collections.reverse(this.lastCategories);
                this.currentCategory = category;
            }
        }
        this.displayedCategories = this.currentCategory.getCategories().size();
    }

    @SubscribeEvent
    public void onEquipmentChange(EquipmentChangedEvent event) {
        if (this.isOpen && event.getEntity() == TheBetweenlands.proxy.getClientPlayer()) {
            this.scheduleMenuUpdate();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (this.isOpen) {
            if (event.phase == TickEvent.Phase.START) {
                if (this.repositionMouse) {
                    Mouse.setCursorPosition((int)this.prevMouseX, (int)this.prevMouseY);
                }
                if (this.isOpen) {
                    this.displayedCategories = this.currentCategory.getCategories().size();
                }
            } else {
                EntityPlayer player;
                if (this.repositionMouse) {
                    Mouse.setCursorPosition((int)this.prevMouseX, (int)this.prevMouseY);
                    this.repositionMouse = false;
                }
                this.prevMouseX = Mouse.getX();
                this.prevMouseY = Mouse.getY();
                if (this.scheduleMenuUpdate) {
                    this.scheduleMenuUpdate = false;
                    this.updateMenu();
                }
                if ((player = TheBetweenlands.proxy.getClientPlayer()) != null) {
                    ArrayList<ItemStack> currentEquippables = new ArrayList<ItemStack>();
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
                        currentEquippables.add(stack);
                    }
                    this.equippables.removeAll(currentEquippables);
                    if (!this.equippables.isEmpty()) {
                        this.updateMenu();
                    }
                    this.equippables.clear();
                    this.equippables.addAll(currentEquippables);
                }
            }
        }
    }

    @SubscribeEvent
    public void renderGui(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            int i;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r != null && this.isOpen) {
                this.closeGUI();
                return;
            }
            if (!this.isOpen || this.currentCategory == null) {
                return;
            }
            GlStateManager.func_179092_a((int)516, (float)0.0f);
            ScaledResolution res = new ScaledResolution(mc);
            this.guiX = res.func_78326_a() / 2;
            this.guiY = res.func_78328_b() / 2;
            float circleAngle = 360.0f / (float)this.currentCategory.getCategories().size();
            double mouseX = this.prevMouseX * res.func_78326_a() / mc.field_71443_c;
            double mouseY = res.func_78328_b() - this.prevMouseY * res.func_78328_b() / mc.field_71440_d;
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
            double diffX = (double)this.guiX - mouseX;
            double diffY = (double)this.guiY - mouseY;
            double centerDistance = Math.sqrt(diffX * diffX + diffY * diffY);
            mc.field_71446_o.func_110577_a(TEXTURE);
            int segments = Math.min(this.currentCategory.getCategories().size(), this.displayedCategories);
            for (i = 0; i < segments; ++i) {
                float midAngle = (float)i * circleAngle + circleAngle / 2.0f;
                double xOffset = Math.sin(Math.toRadians(midAngle));
                double yOffset = Math.cos(Math.toRadians(180.0f - midAngle));
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)((double)this.guiX + xOffset * (double)segments * 2.8), (double)((double)this.guiY + yOffset * (double)segments * 2.8), (double)0.0);
                GlStateManager.func_179114_b((float)(180.0f + 360.0f / (float)Math.min(this.currentCategory.getCategories().size(), this.displayedCategories)), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179114_b((float)((float)i * circleAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                double radius = this.radius;
                double circumference = Math.PI * radius * 2.0;
                double innerRadius = this.innerRadius;
                double wrapRadius = (radius - innerRadius - 8.0) * 1.0;
                if (this.isInside((int)mouseX, (int)mouseY, i)) {
                    radius += 5.0;
                }
                double maxAngle = 360.0 / (double)Math.min(this.currentCategory.getCategories().size(), this.displayedCategories);
                int subSegments = (int)(maxAngle / 10.0);
                double wrapAngle = 90.0 * circumference / (Math.PI * radius * 2.0);
                double textureWidth = 160.0;
                double textureHeight = 64.0;
                GuiUtils.renderMappedCircleSegmentWrapped(subSegments, maxAngle, wrapAngle, wrapRadius, radius, MathHelper.func_151237_a((double)(innerRadius - (double)segments * 2.5), (double)10.0, (double)innerRadius), 8.0, 0.0 / textureWidth, 100.0 / textureWidth, 10.0 / textureHeight, 47.0 / textureHeight, 111.0 / textureWidth, 120.0 / textureWidth, 10.0 / textureHeight, 47.0 / textureHeight, 0.0 / textureWidth, 100.0 / textureWidth, 0.0 / textureHeight, 9.0 / textureHeight, 121.0 / textureWidth, 130.0 / textureWidth, 10.0 / textureHeight, 47.0 / textureHeight, 0.0 / textureWidth, 100.0 / textureWidth, 48.0 / textureHeight, 57.0 / textureHeight, 102.0 / textureWidth, 110.0 / textureWidth, 1.0 / textureHeight, 9.0 / textureHeight, 102.0 / textureWidth, 110.0 / textureWidth, 11.0 / textureHeight, 19.0 / textureHeight, 102.0 / textureWidth, 110.0 / textureWidth, 21.0 / textureHeight, 29.0 / textureHeight, 102.0 / textureWidth, 110.0 / textureWidth, 31.0 / textureHeight, 39.0 / textureHeight);
                GlStateManager.func_179092_a((int)516, (float)0.1f);
                GlStateManager.func_179098_w();
                GlStateManager.func_179121_F();
            }
            for (i = 0; i < Math.min(this.currentCategory.getCategories().size(), this.displayedCategories); ++i) {
                Category category = this.currentCategory.getCategories().get(i);
                float midAngle = (float)i * circleAngle + circleAngle / 2.0f;
                double yOffset = Math.cos(Math.toRadians(180.0f - midAngle)) * (double)segments * 2.8;
                double xOffset = Math.sin(Math.toRadians(midAngle)) * (double)segments * 2.8;
                double dst = Math.sqrt(xOffset * xOffset + yOffset * yOffset);
                category.renderCategory((double)this.guiX + xOffset, (double)this.guiY + yOffset, xOffset / dst, yOffset / dst, this.radius - this.innerRadius - 8, xOffset / dst * (double)this.innerRadius, yOffset / dst * (double)this.innerRadius, ((double)i + 0.5) * (double)circleAngle, circleAngle);
            }
            GlStateManager.func_179147_l();
            if (centerDistance > (double)(this.innerRadius - 2)) {
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.1f);
            } else {
                GlStateManager.func_179131_c((float)0.1f, (float)0.1f, (float)0.1f, (float)0.3f);
            }
            GuiUtils.drawCircle(this.guiX, this.guiY, this.innerRadius - 2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            for (i = 0; i < Math.min(this.currentCategory.getCategories().size(), this.displayedCategories); ++i) {
                Category category = this.currentCategory.getCategories().get(i);
                float midAngle = (float)i * circleAngle + circleAngle / 2.0f;
                int width = mc.field_71466_p.func_78256_a(category.getName());
                GlStateManager.func_179098_w();
                double startX = (double)this.guiX + Math.sin(Math.toRadians(midAngle)) * (double)(this.radius + 5);
                double startY = (double)this.guiY + Math.cos(Math.toRadians(180.0f - midAngle)) * (double)(this.radius + 5);
                double endX = (double)this.guiX + Math.sin(Math.toRadians(midAngle)) * (double)(this.radius + 40);
                double endY = (double)this.guiY + Math.cos(Math.toRadians(180.0f - midAngle)) * (double)(this.radius + 40);
                int color = this.isInside((int)mouseX, (int)mouseY, i) ? category.getHighlightColor() : category.getColor();
                float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
                float red = (float)(color >> 16 & 0xFF) / 255.0f;
                float green = (float)(color >> 8 & 0xFF) / 255.0f;
                float blue = (float)(color & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
                GL11.glEnable((int)2848);
                GlStateManager.func_179147_l();
                GlStateManager.func_179090_x();
                GlStateManager.func_187441_d((float)3.0f);
                GlStateManager.func_179094_E();
                double yOffset = Math.cos(Math.toRadians(180.0f - midAngle)) * (double)segments * 2.8;
                double xOffset = Math.sin(Math.toRadians(midAngle)) * (double)segments * 2.8;
                GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)0.0);
                GlStateManager.func_187447_r((int)1);
                GL11.glVertex2d((double)startX, (double)startY);
                if (Math.abs(endX - (double)this.guiX) > 1.0) {
                    GL11.glVertex2d((double)endX, (double)((int)endY));
                } else {
                    GL11.glVertex2d((double)endX, (double)((int)endY - 1));
                }
                if (Math.abs(endX - (double)this.guiX) > 1.0) {
                    GL11.glVertex2d((double)endX, (double)((int)endY));
                    if (endX < (double)this.guiX) {
                        GL11.glVertex2d((double)(this.guiX - 100), (double)((int)endY));
                    } else {
                        GL11.glVertex2d((double)(this.guiX + 99), (double)((int)endY));
                    }
                }
                GlStateManager.func_187437_J();
                GlStateManager.func_179098_w();
                int textColor = -1;
                if (endX < (double)(this.guiX - 1)) {
                    Gui.func_73734_a((int)(this.guiX - 100 - width - 1), (int)((int)endY - 8), (int)(this.guiX - 100), (int)((int)endY + 1), (int)color);
                    mc.field_71466_p.func_78276_b(category.getName(), this.guiX - 100 - width, (int)endY - 7, textColor);
                } else if (endX > (double)(this.guiX + 1)) {
                    Gui.func_73734_a((int)(this.guiX + 100 - 1), (int)((int)endY - 8), (int)(this.guiX + 100 + width), (int)((int)endY + 1), (int)color);
                    mc.field_71466_p.func_78276_b(category.getName(), this.guiX + 100, (int)endY - 7, textColor);
                } else {
                    Gui.func_73734_a((int)(this.guiX - width / 2 - 1), (int)((int)endY - 1), (int)(this.guiX - width / 2 + width), (int)((int)endY + 8), (int)color);
                    mc.field_71466_p.func_78276_b(category.getName(), this.guiX - width / 2, (int)endY, textColor);
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179098_w();
            if (this.currentCategory != this.rootCategory) {
                String categoryName = "";
                for (int i2 = 1; i2 < this.lastCategories.size(); ++i2) {
                    Category category = this.lastCategories.get(i2);
                    categoryName = categoryName + category.getName() + " > ";
                }
                categoryName = categoryName + this.currentCategory.getName();
                int width = mc.field_71466_p.func_78256_a(categoryName);
                mc.field_71466_p.func_78276_b(categoryName, this.guiX - width / 2, this.guiY - this.radius - 60, -1);
            }
            GL11.glDisable((int)2848);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    private void onMouseClick(int mouseX, int mouseY, int mouseButton) {
        block5: {
            block4: {
                double diffX = this.guiX - mouseX;
                double diffY = this.guiY - mouseY;
                double length = Math.sqrt(diffX * diffX + diffY * diffY);
                if (!(length <= (double)(this.innerRadius - 2))) break block4;
                if (this.lastCategories.size() <= 0) break block5;
                this.currentCategory = this.lastCategories.get(this.lastCategories.size() - 1);
                this.lastCategories.remove(this.lastCategories.size() - 1);
                this.displayedCategories = this.currentCategory.getCategories().size();
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                break block5;
            }
            for (int i = 0; i < Math.min(this.currentCategory.getCategories().size(), this.displayedCategories); ++i) {
                if (!this.isInside(mouseX, mouseY, i)) continue;
                Category category = this.currentCategory.getCategories().get(i);
                if (category.getCategories().size() > 0) {
                    this.lastCategories.add(this.currentCategory);
                    this.currentCategory = category;
                    this.displayedCategories = this.currentCategory.getCategories().size();
                } else if (category.onClicked(mouseX, mouseY, mouseButton)) {
                    this.closeGUI();
                }
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                break;
            }
        }
    }

    private boolean isInside(int x, int y, int category) {
        double diffX = this.guiX - x;
        double diffY = this.guiY - y;
        float circleAngle = 360.0f / (float)this.currentCategory.getCategories().size();
        double length = Math.sqrt(diffX * diffX + diffY * diffY);
        double angle = (360.0 - (Math.toDegrees(Math.atan2(diffX, diffY)) + 180.0) + 180.0) % 360.0;
        int segments = Math.min(this.currentCategory.getCategories().size(), this.displayedCategories);
        return angle >= (double)((int)((float)category * circleAngle)) && angle < (double)((int)((float)(category + 1) * circleAngle)) && length <= (double)this.radius + (double)segments * 2.0 && length >= MathHelper.func_151237_a((double)((double)this.innerRadius - (double)segments * 2.8), (double)10.0, (double)this.innerRadius) + (double)segments * 2.0 - 4.0;
    }

    public static class Category {
        private Category parent;
        private int index;
        private List<Category> categories = new ArrayList<Category>();
        private String name;
        private int color;
        private int highlightColor;

        public Category(String name, int color, int highlightColor) {
            this.name = name;
            this.color = color;
            this.highlightColor = highlightColor;
        }

        public int getColor() {
            return this.color;
        }

        public int getHighlightColor() {
            return this.highlightColor;
        }

        public String getName() {
            return this.name;
        }

        public List<Category> getCategories() {
            return this.categories;
        }

        public Category getCategory(String name) {
            Category category = null;
            for (Category cCategory : this.categories) {
                if (!cCategory.name.equalsIgnoreCase(name)) continue;
                category = cCategory;
                break;
            }
            return category;
        }

        public Category addCategory(Category category) {
            category.parent = this;
            this.categories.add(category);
            return this;
        }

        public Category getByName(String name) {
            Category category = null;
            for (Category cCategory : this.categories) {
                if (!cCategory.name.equalsIgnoreCase(name)) continue;
                category = cCategory;
                break;
            }
            return category;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void setHighlightColor(int color) {
            this.highlightColor = color;
        }

        public void renderCategory(double centerX, double centerY, double dirX, double dirY, double radius, double startX, double startY, double angle, double segmentAngle) {
        }

        public boolean onClicked(int mouseX, int mouseY, int mouseButton) {
            return false;
        }
    }
}

