/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.handler;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.capability.IFoodSicknessCapability;
import thebetweenlands.api.item.IDecayFood;
import thebetweenlands.api.item.IEquippable;
import thebetweenlands.api.item.IFoodSicknessItem;
import thebetweenlands.api.recipes.ICompostBinRecipe;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.capability.foodsickness.FoodSickness;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.handler.FoodSicknessHandler;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.recipe.censer.AbstractCenserRecipe;
import thebetweenlands.common.recipe.misc.AnimatorRecipe;
import thebetweenlands.common.recipe.misc.CompostRecipe;
import thebetweenlands.common.recipe.mortar.PestleAndMortarRecipe;
import thebetweenlands.common.recipe.purifier.PurifierRecipe;
import thebetweenlands.common.registries.CapabilityRegistry;

public class ItemTooltipHandler {
    public static final DecimalFormat COMPOST_AMOUNT_FORMAT = new DecimalFormat("#.##");

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List toolTip = event.getToolTip();
        EntityPlayer player = event.getEntityPlayer();
        CircleGemType circleGem = CircleGemHelper.getGem(stack);
        if (circleGem != CircleGemType.NONE) {
            toolTip.add(I18n.func_135052_a((String)("tooltip.bl.circlegem." + circleGem.name), (Object[])new Object[0]));
        }
        if (stack.func_77973_b() instanceof IDecayFood) {
            ((IDecayFood)stack.func_77973_b()).getDecayFoodTooltip(stack, player != null ? player.field_70170_p : null, toolTip, event.getFlags());
        } else if (OverworldItemHandler.getDecayFoodStats(stack) != null) {
            toolTip.add(I18n.func_135052_a((String)"tooltip.bl.decay_food", (Object[])new Object[]{stack.func_82833_r()}));
        }
        if (player != null) {
            IFoodSicknessCapability cap;
            if (FoodSicknessHandler.isFoodSicknessEnabled(player.func_130014_f_()) && stack.func_77973_b() instanceof ItemFood && stack.func_77973_b() instanceof IFoodSicknessItem && ((IFoodSicknessItem)stack.func_77973_b()).canGetSickOf(player, stack) && (cap = (IFoodSicknessCapability)player.getCapability(CapabilityRegistry.CAPABILITY_FOOD_SICKNESS, null)) != null) {
                FoodSickness sickness = cap.getSickness(stack.func_77973_b());
                int hatred = cap.getFoodHatred(stack.func_77973_b());
                ((IFoodSicknessItem)stack.func_77973_b()).getSicknessTooltip(stack, sickness, hatred, event.getFlags().func_194127_a(), toolTip);
            }
            if (stack.func_77973_b() instanceof IEquippable && ((IEquippable)stack.func_77973_b()).canEquip(stack, player, (Entity)player)) {
                toolTip.add(I18n.func_135052_a((String)"tooltip.bl.item.equippable", (Object[])new Object[0]));
            }
        }
        if (BetweenlandsConfig.GENERAL.itemUsageTooltip) {
            ICompostBinRecipe compostRecipe;
            ArrayList<String> usedInMachines = new ArrayList<String>();
            if (player != null) {
                AspectManager aspectManager = AspectManager.get(player.field_70170_p);
                if (!aspectManager.getStaticAspects(stack).isEmpty()) {
                    usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.static_aspects", (Object[])new Object[0]));
                }
                if (!ItemAspectContainer.fromItem(stack, aspectManager).isEmpty()) {
                    usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.aspects", (Object[])new Object[0]));
                }
            }
            if (!PestleAndMortarRecipe.getResult(stack, stack.func_77946_l(), true).func_190926_b()) {
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.mortar", (Object[])new Object[0]));
            }
            if (AnimatorRecipe.getRecipe(stack) != null) {
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.animator", (Object[])new Object[0]));
            }
            IFluidHandler fluidHandler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (AbstractCenserRecipe.getRecipe(stack) != null || fluidHandler != null && AbstractCenserRecipe.getRecipe(fluidHandler.drain(Integer.MAX_VALUE, false)) != null) {
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.censer_primary", (Object[])new Object[0]));
            }
            if (AbstractCenserRecipe.getRecipeWithSecondaryInput(stack) != null) {
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.censer_secondary", (Object[])new Object[0]));
            }
            if (!PurifierRecipe.getRecipeOutput(stack).func_190926_b()) {
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.purifier", (Object[])new Object[0]));
            }
            if ((compostRecipe = CompostRecipe.getCompostRecipe(stack)) != null) {
                String debug = "";
                if (event.getFlags().func_194127_a()) {
                    debug = " (T: " + COMPOST_AMOUNT_FORMAT.format((float)compostRecipe.getCompostingTime(stack) / 20.0f) + "s A: " + compostRecipe.getCompostAmount(stack) + ")";
                }
                usedInMachines.add(I18n.func_135052_a((String)"tooltip.bl.recipes.compost_bin", (Object[])new Object[0]) + debug);
            }
            if (!usedInMachines.isEmpty()) {
                toolTip.add(I18n.func_135052_a((String)"tooltip.bl.recipes.used_in", (Object[])new Object[]{usedInMachines.stream().collect(Collectors.joining(", "))}));
            }
        }
    }

    public static List<String> splitTooltip(String tooltip, int indent) {
        String indentStr = new String(new char[indent]).replace('\u0000', ' ');
        return ItemTooltipHandler.splitTooltip(tooltip, indentStr);
    }

    public static List<String> splitTooltip(String tooltip, String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] splits = tooltip.split("\\\\n");
        for (int i = 0; i < splits.length; ++i) {
            splits[i] = prefix + splits[i];
        }
        lines.addAll(Arrays.asList(splits));
        return lines;
    }

    static {
        COMPOST_AMOUNT_FORMAT.setRoundingMode(RoundingMode.CEILING);
    }
}

