/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience.list;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;
import thebetweenlands.client.audio.ambience.AmbienceLayer;
import thebetweenlands.client.audio.ambience.AmbienceType;
import thebetweenlands.common.registries.AmbienceRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityPresent;
import thebetweenlands.common.world.event.EventWinter;

public class PresentAmbienceType
extends AmbienceType {
    @Nullable
    protected TileEntityPresent getClosestPresent(EntityPlayer player, double range) {
        int sx = MathHelper.func_76128_c((double)(player.field_70165_t - range)) >> 4;
        int sz = MathHelper.func_76128_c((double)(player.field_70161_v - range)) >> 4;
        int ex = MathHelper.func_76128_c((double)(player.field_70165_t + range)) >> 4;
        int ez = MathHelper.func_76128_c((double)(player.field_70161_v + range)) >> 4;
        TileEntityPresent closest = null;
        for (int cx = sx; cx <= ex; ++cx) {
            for (int cz = sz; cz <= ez; ++cz) {
                Chunk chunk = player.field_70170_p.func_72964_e(cx, cz);
                for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                    double dstSq;
                    TileEntity tile = (TileEntity)entry.getValue();
                    if (!(tile instanceof TileEntityPresent) || !((dstSq = ((BlockPos)entry.getKey()).func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v)) <= range * range) || closest != null && !(dstSq <= closest.func_174877_v().func_177954_c(player.field_70165_t, player.field_70163_u, player.field_70161_v))) continue;
                    closest = (TileEntityPresent)tile;
                }
            }
        }
        return closest;
    }

    @Override
    public boolean isActive() {
        return EventWinter.isFroooosty(this.getPlayer().field_70170_p) && this.getClosestPresent(this.getPlayer(), 32.0) != null;
    }

    @Override
    public AmbienceLayer getAmbienceLayer() {
        return AmbienceRegistry.BASE_LAYER;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public SoundCategory getCategory() {
        return SoundCategory.RECORDS;
    }

    @Override
    public SoundEvent getSound() {
        return SoundRegistry.CHRISTMAS_ON_THE_MARSH;
    }

    @Override
    public float getVolume() {
        TileEntityPresent present = this.getClosestPresent(this.getPlayer(), 32.0);
        if (present != null) {
            float volume = 1.0f - MathHelper.func_76131_a((float)((float)Math.sqrt(present.func_145835_a(this.getPlayer().field_70165_t, this.getPlayer().field_70163_u, this.getPlayer().field_70161_v)) / 64.0f), (float)0.0f, (float)1.0f);
            return volume * volume * 0.3f;
        }
        return 0.0f;
    }

    @Override
    public float getLowerPriorityVolume() {
        return 1.0f;
    }
}

