/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerRenderCape
extends Transformer {
    private static final String CLASS = "net.minecraft.client.renderer.entity.layers.LayerCape";

    @Override
    public boolean needToComputeFrames() {
        return true;
    }

    @Override
    public boolean isAllowedToFail() {
        return true;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode render = TransformUtil.findMethod(classNode, TransformUtil.remapMethodName("net/minecraft/client/renderer/entity/layers/LayerCape", "func_177141_a", Type.VOID_TYPE, Type.getType((String)"Lnet/minecraft/client/entity/AbstractClientPlayer;"), Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE), "(Lnet/minecraft/client/entity/AbstractClientPlayer;FFFFFFF)V");
            int check = TransformUtil.findFirstField(render, 0, TransformUtil.remapFieldName("net/minecraft/init/Items", "field_185160_cR"), "Lnet/minecraft/item/Item;", "net/minecraft/init/Items");
            if (check == -1) throw new TransformerException("Could not locate required instructions");
            if (render.instructions.get(check).getNext().getOpcode() == 165) {
                AbstractInsnNode insertAfter = render.instructions.get(check).getNext();
                LabelNode label = ((JumpInsnNode)insertAfter).label;
                render.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, label));
                render.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/client/internal/TAHooksClient", "shouldRenderCape", "(Lnet/minecraft/client/entity/AbstractClientPlayer;)Z", false));
                render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
                return true;
            } else {
                AbstractInsnNode insertAfter = render.instructions.get(check).getPrevious().getPrevious().getPrevious();
                LabelNode newLabel = new LabelNode(new Label());
                render.instructions.insert(insertAfter, (AbstractInsnNode)new JumpInsnNode(153, newLabel));
                render.instructions.insert(insertAfter, (AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/client/internal/TAHooksClient", "shouldRenderCape", "(Lnet/minecraft/client/entity/AbstractClientPlayer;)Z", false));
                render.instructions.insert(insertAfter, (AbstractInsnNode)new VarInsnNode(25, 1));
                check = TransformUtil.findFirstInstanceOfOpcode(render, check, 177);
                if (check == -1) throw new TransformerException("Could not locate required instructions, complex case");
                render.instructions.insert(render.instructions.get(check).getPrevious(), (AbstractInsnNode)newLabel);
            }
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

