/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerCycleItemStackMetadata
extends Transformer {
    private static final String CLASS = "thaumcraft.common.lib.utils.InventoryUtils";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode cycle = TransformUtil.findMethod(classNode, "cycleItemStack", "(Ljava/lang/Object;I)Lnet/minecraft/item/ItemStack;");
            int ret = TransformUtil.findFirstInstanceOfMethodCall(cycle, 0, TransformUtil.remapMethodName("net/minecraft/item/ItemStack", "func_77984_f", Type.BOOLEAN_TYPE, new Type[0]), "()Z", "net/minecraft/item/ItemStack");
            if (ret == -1) throw new TransformerException("Could not locate required instructions");
            JumpInsnNode target = (JumpInsnNode)cycle.instructions.get(ret).getNext();
            Label targetLabel = target.label.getLabel();
            int labelIndex = TransformUtil.findExactLabel(cycle, targetLabel);
            if (labelIndex == -1) throw new TransformerException("Could not locate jump target label");
            ret = TransformUtil.findFirstInstanceOfOpcode(cycle, labelIndex, 176);
            if (ret == -1) {
                throw new TransformerException("Could not locate return after jump target");
            }
            InsnList insns = new InsnList();
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insns.add((AbstractInsnNode)new VarInsnNode(21, 1));
            insns.add((AbstractInsnNode)new MethodInsnNode(184, "thecodex6824/thaumicaugmentation/common/internal/TAHooksCommon", "cycleItemStack", "(Lnet/minecraft/item/ItemStack;Ljava/lang/Object;I)Lnet/minecraft/item/ItemStack;", false));
            cycle.instructions.insert(cycle.instructions.get(ret).getPrevious(), insns);
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

