/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thecodex6824.thaumicaugmentation.api.TAConfig;

public final class FractureLocatorSearchManager {
    private static WeakHashMap<EntityPlayer, Long> locationRequestTimes = new WeakHashMap();
    private static HashMap<Integer, HashSet<BlockPos>> locations = new HashMap();

    private FractureLocatorSearchManager() {
    }

    public static boolean canPlayerRequestLocation(EntityPlayer player) {
        Long lastRequest = locationRequestTimes.get(player);
        return lastRequest == null || lastRequest < System.currentTimeMillis() - (long)TAConfig.fractureLocatorUpdateInterval.getValue().intValue();
    }

    public static void resetPlayerLocationTime(EntityPlayer player) {
        locationRequestTimes.put(player, System.currentTimeMillis());
    }

    @Nullable
    private static BlockPos findNearest(BlockPos point, HashSet<BlockPos> choices) {
        long minDist = Long.MAX_VALUE;
        BlockPos ret = null;
        for (BlockPos pos : choices) {
            long dist = (long)point.func_177951_i((Vec3i)pos);
            if (dist >= minDist) continue;
            minDist = dist;
            ret = pos;
        }
        return ret;
    }

    @Nullable
    public static BlockPos findNearestFracture(World world, BlockPos pos) {
        if (locations.containsKey(world.field_73011_w.getDimension())) {
            return FractureLocatorSearchManager.findNearest(pos, locations.get(world.field_73011_w.getDimension()));
        }
        return null;
    }

    public static void addFractureLocation(World world, BlockPos pos) {
        if (!locations.containsKey(world.field_73011_w.getDimension())) {
            locations.put(world.field_73011_w.getDimension(), new HashSet());
        }
        locations.get(world.field_73011_w.getDimension()).add(pos);
    }

    public static void addFractureLocations(World world, Collection<BlockPos> pos) {
        if (!locations.containsKey(world.field_73011_w.getDimension())) {
            locations.put(world.field_73011_w.getDimension(), new HashSet());
        }
        locations.get(world.field_73011_w.getDimension()).addAll(pos);
    }

    public static void removeFractureLocations(World world, BlockPos pos) {
        if (locations.containsKey(world.field_73011_w.getDimension())) {
            locations.get(world.field_73011_w.getDimension()).remove(pos);
        }
    }

    public static void removeFractureLocations(World world, Collection<BlockPos> pos) {
        if (locations.containsKey(world.field_73011_w.getDimension())) {
            locations.get(world.field_73011_w.getDimension()).removeAll(pos);
        }
    }
}

