/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.casters.ICaster;
import thaumcraft.common.lib.SoundsTC;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.api.augment.Augment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.entity.IDimensionalFracture;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusAPI;
import thecodex6824.thaumicaugmentation.api.impetus.ImpetusStorage;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderAugmentRiftEnergyStorage;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;
import thecodex6824.thaumicaugmentation.common.tile.TileEldritchLock;
import thecodex6824.thaumicaugmentation.common.util.ItemHelper;

public class ItemRiftEnergyCasterAugment
extends ItemTABase {
    public ItemRiftEnergyCasterAugment() {
        super(new String[0]);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityProviderAugmentRiftEnergyStorage storage = new CapabilityProviderAugmentRiftEnergyStorage(new Augment(){
            private boolean syncNeeded;

            @Override
            public boolean canBeAppliedToItem(ItemStack augmentable) {
                return augmentable.func_77973_b() instanceof ICaster;
            }

            @Override
            public boolean isCompatible(ItemStack otherAugment) {
                return stack.func_77973_b() != otherAugment.func_77973_b();
            }

            @Override
            public boolean onCastPre(ItemStack caster, FocusWrapper focusPackage, Entity user) {
                IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                if (energy != null && energy.extractEnergy(10L, true) == 10L) {
                    focusPackage.setFocusPower(focusPackage.getFocusPower() * TAConfig.impetusConductorFactor.getValue().floatValue());
                }
                return false;
            }

            @Override
            public boolean onTick(Entity user) {
                IImpetusStorage stackStorage;
                if (!user.func_130014_f_().field_72995_K && user.func_130014_f_().func_82737_E() % 20L == 0L && (stackStorage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)) != null && stackStorage.canReceive() && stackStorage.getEnergyStored() < stackStorage.getMaxEnergyStored()) {
                    this.syncNeeded = ImpetusAPI.drainNearbyEnergyIntoStorage(user.func_130014_f_(), stackStorage, user.func_174813_aQ().func_72314_b((double)(user.field_70130_N * 2.0f), (double)user.field_70131_O, (double)(user.field_70130_N * 2.0f)), user.func_174791_d().func_72441_c(0.0, (double)(user.field_70131_O / 2.0f), 0.0));
                    if (stackStorage.getEnergyStored() == stackStorage.getMaxEnergyStored()) {
                        user.func_130014_f_().func_184133_a(null, user.func_180425_c(), SoundsTC.runicShieldEffect, SoundCategory.PLAYERS, 0.5f + user.func_130014_f_().field_73012_v.nextFloat() / 5.0f, 0.75f + user.func_130014_f_().field_73012_v.nextFloat() / 2.0f);
                    }
                }
                return false;
            }

            @Override
            public boolean onInteractBlock(Entity user, ItemStack used, BlockPos target, EnumFacing face, EnumHand hand) {
                World world = user.func_130014_f_();
                if (!world.field_72995_K && world.func_180495_p(target).func_177230_c() == TABlocks.ELDRITCH_LOCK_IMPETUS) {
                    TileEntity tile = world.func_175625_s(target);
                    IImpetusStorage stackStorage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                    if (tile instanceof TileEldritchLock && ImpetusAPI.tryExtractFully(stackStorage, 30L, user)) {
                        ((TileEldritchLock)tile).open();
                        world.func_184133_a(null, target, TASounds.RIFT_ENERGY_ZAP, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        for (int i = 0; i < 4; ++i) {
                            ImpetusAPI.createImpetusParticles(world, user.func_174791_d().func_72441_c(0.0, (double)(user.field_70131_O / 2.0f), 0.0), new Vec3d((Vec3i)target));
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean onInteractEntity(Entity user, ItemStack used, Entity target, EnumHand hand) {
                IImpetusStorage stackStorage;
                IDimensionalFracture fracture;
                if (!user.func_130014_f_().field_72995_K && target instanceof IDimensionalFracture && !(fracture = (IDimensionalFracture)target).isOpening() && !fracture.isOpen() && ImpetusAPI.tryExtractFully(stackStorage = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null), 15L, user)) {
                    fracture.open();
                    target.func_184185_a(TASounds.RIFT_ENERGY_ZAP, 0.5f + target.func_130014_f_().field_73012_v.nextFloat() / 5.0f, 0.75f + target.func_130014_f_().field_73012_v.nextFloat() / 2.0f);
                    for (int i = 0; i < 3; ++i) {
                        TANetwork.INSTANCE.sendToAllAround((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.VOID_STREAKS, user.field_70165_t, user.field_70163_u + (double)(user.field_70131_O / 2.0f), user.field_70161_v, target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v, 0.08f), new NetworkRegistry.TargetPoint(user.func_130014_f_().field_73011_w.getDimension(), user.field_70165_t, user.field_70163_u, user.field_70161_v, 64.0));
                    }
                    this.syncNeeded = true;
                }
                return false;
            }

            @Override
            public boolean shouldSync() {
                boolean sync = this.syncNeeded;
                this.syncNeeded = false;
                return sync;
            }

            @Override
            public boolean hasAdditionalAugmentTooltip() {
                return true;
            }

            @Override
            public void appendAdditionalAugmentTooltip(List<String> tooltip) {
                IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                if (energy != null) {
                    tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.stored_energy", new Object[]{ImpetusAPI.getSuggestedChatColorForDescriptor(energy) + new TextComponentTranslation(ImpetusAPI.getEnergyAmountDescriptor(energy), new Object[0]).func_150254_d()}).func_150254_d());
                }
            }
        }, new ImpetusStorage(300L, 15L));
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            storage.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return storage;
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound energy;
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            NBTTagCompound item = stack.func_77978_p().func_74737_b();
            if (!ThaumicAugmentation.proxy.isSingleplayer() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                item.func_82580_o("cap");
            }
            tag.func_74782_a("item", (NBTBase)item);
        }
        tag.func_74782_a("cap", (NBTBase)new NBTTagCompound());
        NBTTagCompound augment = ItemHelper.tryMakeCapabilityTag(stack, CapabilityAugment.AUGMENT);
        if (augment != null) {
            tag.func_74775_l("cap").func_74782_a("augment", (NBTBase)augment);
        }
        if ((energy = ItemHelper.tryMakeCapabilityTag(stack, CapabilityImpetusStorage.IMPETUS_STORAGE)) != null) {
            tag.func_74775_l("cap").func_74782_a("energy", (NBTBase)energy);
        }
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((Augment)stack.getCapability(CapabilityAugment.AUGMENT, null)).deserializeNBT(nbt.func_74775_l("cap").func_74775_l("augment"));
                ((ImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null)).deserializeNBT(nbt.func_74775_l("cap").func_74775_l("energy"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            ItemStack empty = new ItemStack((Item)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((Item)this);
            IImpetusStorage energy = (IImpetusStorage)full.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
            while (energy.getEnergyStored() < energy.getMaxEnergyStored()) {
                energy.receiveEnergy(energy.getMaxEnergyStored(), false);
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!full.func_77942_o()) {
                    full.func_77982_d(new NBTTagCompound());
                }
                full.func_77978_p().func_74782_a("cap", (NBTBase)new NBTTagCompound());
                full.func_77978_p().func_74775_l("cap").func_74782_a("augment", (NBTBase)((Augment)full.getCapability(CapabilityAugment.AUGMENT, null)).serializeNBT());
                full.func_77978_p().func_74775_l("cap").func_74782_a("energy", (NBTBase)((ImpetusStorage)energy).serializeNBT());
            }
            items.add((Object)full);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        IImpetusStorage energy = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        if (energy != null) {
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.stored_energy", new Object[]{ImpetusAPI.getSuggestedChatColorForDescriptor(energy) + new TextComponentTranslation(ImpetusAPI.getEnergyAmountDescriptor(energy), new Object[0]).func_150254_d()}).func_150254_d());
        }
    }
}

