/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import baubles.api.BaubleType;
import baubles.api.cap.BaubleItem;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.items.RechargeHelper;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.augment.AugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugment;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugment;
import thecodex6824.thaumicaugmentation.api.augment.builder.IElytraHarnessAugment;
import thecodex6824.thaumicaugmentation.common.capability.provider.CapabilityProviderHarness;
import thecodex6824.thaumicaugmentation.common.event.AugmentEventHandler;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.item.trait.IElytraCompat;
import thecodex6824.thaumicaugmentation.common.util.ItemHelper;
import vazkii.botania.api.item.IPhantomInkable;

@Optional.Interface(iface="vazkii.botania.api.item.IPhantomInkable", modid="botania")
public class ItemElytraHarness
extends ItemTABase
implements IElytraCompat,
IRechargable,
IPhantomInkable {
    protected static final int VIS_MAX = 50;

    public ItemElytraHarness() {
        super(new String[0]);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(221);
        this.setNoRepair();
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        CapabilityProviderHarness provider = new CapabilityProviderHarness(new AugmentableItem(2){

            @Override
            public boolean isAugmentAcceptable(ItemStack augment, int slot) {
                if (!(augment.getCapability(CapabilityAugment.AUGMENT, null) instanceof IElytraHarnessAugment)) {
                    return false;
                }
                if (((IElytraHarnessAugment)augment.getCapability(CapabilityAugment.AUGMENT, null)).isCosmetic()) {
                    for (ItemStack stack : this.getAllAugments()) {
                        IAugment aug;
                        if (stack.func_190926_b() || !((aug = (IAugment)stack.getCapability(CapabilityAugment.AUGMENT, null)) instanceof IElytraHarnessAugment) || !((IElytraHarnessAugment)aug).isCosmetic()) continue;
                        return false;
                    }
                } else {
                    for (ItemStack stack : this.getAllAugments()) {
                        IAugment aug;
                        if (stack.func_190926_b() || !((aug = (IAugment)stack.getCapability(CapabilityAugment.AUGMENT, null)) instanceof IElytraHarnessAugment) || ((IElytraHarnessAugment)aug).isCosmetic()) continue;
                        return false;
                    }
                }
                return true;
            }
        }, new BaubleItem(BaubleType.BODY){
            protected boolean sync;

            public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
                AugmentEventHandler.onEquipmentChange(player);
                this.sync = true;
            }

            public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
                AugmentEventHandler.onEquipmentChange(player);
            }

            public void onWornTick(ItemStack stack, EntityLivingBase entity) {
                if (!entity.field_70170_p.field_72995_K) {
                    if (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_() && (entity.field_184629_bo + 1) % 20 == 0) {
                        if (RechargeHelper.getCharge((ItemStack)stack) > 0) {
                            RechargeHelper.consumeCharge((ItemStack)stack, (EntityLivingBase)entity, (int)1);
                        } else if (stack.func_77952_i() < stack.func_77958_k() - 1) {
                            stack.func_77972_a(1, entity);
                            this.sync = true;
                        }
                    }
                    if (entity.field_70173_aa % 60 == 0 && entity.field_70122_E && stack.func_77952_i() > 0) {
                        stack.func_77964_b(stack.func_77952_i() - 1);
                        this.sync = true;
                    }
                }
            }

            public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
                boolean res = this.sync;
                this.sync = false;
                return res;
            }
        });
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase entity) {
        if (entity != null && !entity.field_70122_E) {
            return RechargeHelper.getCharge((ItemStack)stack);
        }
        return 50;
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack arg0, EntityLivingBase arg1) {
        return IRechargable.EnumChargeDisplay.PERIODIC;
    }

    @Override
    public boolean allowElytraFlight(EntityPlayer wearer, ItemStack stack) {
        return RechargeHelper.getCharge((ItemStack)stack) > 0 || stack.func_77952_i() < stack.func_77958_k() - 1;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return toRepair.func_77952_i() > 0 && !repair.func_190926_b() && OreDictionary.itemMatches((ItemStack)new ItemStack(ItemsTC.ingots, 1, 1), (ItemStack)repair, (boolean)false);
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return TAMaterials.RARITY_ARCANE;
    }

    @Optional.Method(modid="botania")
    public boolean hasPhantomInk(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74767_n("phantomInk");
        }
        return false;
    }

    @Optional.Method(modid="botania")
    public void setPhantomInk(ItemStack stack, boolean ink) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("phantomInk", ink);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound cap;
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            NBTTagCompound item = stack.func_77978_p().func_74737_b();
            if (!ThaumicAugmentation.proxy.isSingleplayer() && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                item.func_82580_o("cap");
            }
            tag.func_74782_a("item", (NBTBase)item);
        }
        if ((cap = ItemHelper.tryMakeCapabilityTag(stack, CapabilityAugmentableItem.AUGMENTABLE_ITEM)) != null) {
            tag.func_74782_a("cap", (NBTBase)cap);
        }
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            ((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).deserializeNBT(nbt.func_74775_l("cap"));
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }
}

