/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.renderer.texture;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.MinecraftForgeClient;

public class VanillaBannerToElytraTexture
extends AbstractTexture {
    protected static final ResourceLocation ELYTRA_TEXTURE = new ResourceLocation("minecraft", "textures/entity/elytra.png");
    protected ResourceLocation texture;
    protected List<ResourceLocation> patterns;
    protected List<EnumDyeColor> colors;

    public VanillaBannerToElytraTexture(ResourceLocation id, List<ResourceLocation> bannerPatterns, List<EnumDyeColor> bannerColors) {
        this.texture = id;
        this.patterns = bannerPatterns;
        this.colors = bannerColors;
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.func_147631_c();
        try (IResource resource = resourceManager.func_110536_a(this.texture);){
            BufferedImage banner = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
            int type = banner.getType();
            if (type == 0) {
                type = 6;
            }
            BufferedImage temp = new BufferedImage(banner.getWidth(), banner.getHeight(), type);
            Graphics2D g2d = temp.createGraphics();
            g2d.drawImage((Image)banner, 0, 0, null);
            for (int i = 0; i < Math.min(this.patterns.size(), this.colors.size()); ++i) {
                BufferedImage layer;
                ResourceLocation currentTexture = this.patterns.get(i);
                int currentColor = this.colors.get(i).func_193350_e();
                if (currentTexture == null || (layer = MinecraftForgeClient.getImageLayer((ResourceLocation)currentTexture, (IResourceManager)resourceManager)).getWidth() != temp.getWidth() || temp.getHeight() != banner.getHeight() || layer.getType() != 6) continue;
                for (int y = 0; y < layer.getHeight(); ++y) {
                    for (int x = 0; x < layer.getWidth(); ++x) {
                        int color = layer.getRGB(x, y);
                        if ((color & 0xFF000000) == 0) continue;
                        int c = (color & 0xFF0000) << 8 & 0xFF000000;
                        int orig = banner.getRGB(x, y);
                        int nC = MathHelper.func_180188_d((int)orig, (int)currentColor) & 0xFFFFFF;
                        layer.setRGB(x, y, c | nC);
                    }
                }
                g2d.drawImage((Image)layer, 0, 0, null);
            }
            g2d.dispose();
            banner = new BufferedImage(temp.getWidth(), temp.getHeight(), type);
            g2d = banner.createGraphics();
            g2d.scale(-1.0, 1.0);
            g2d.translate(-temp.getWidth(), 0);
            g2d.drawImage((Image)temp, 0, 0, null);
            g2d.dispose();
            try (IResource elytraResource = resourceManager.func_110536_a(ELYTRA_TEXTURE);){
                int x;
                int y;
                BufferedImage elytra = TextureUtil.func_177053_a((InputStream)elytraResource.func_110527_b());
                BufferedImage cutout = new BufferedImage(banner.getWidth(), banner.getHeight(), banner.getType());
                Graphics2D cg2d = cutout.createGraphics();
                cg2d.scale(1.85, 1.85);
                cg2d.drawImage((Image)elytra, -12, 0, null);
                cg2d.dispose();
                BufferedImage img = new BufferedImage(banner.getWidth(), banner.getHeight(), banner.getType());
                int lowestX = cutout.getWidth();
                int lowestY = cutout.getHeight();
                for (y = 0; y < Math.min(img.getHeight(), cutout.getHeight()); ++y) {
                    for (x = 0; x < Math.min(img.getWidth(), cutout.getWidth()); ++x) {
                        if ((cutout.getRGB(x, y) & 0xFF000000) == 0) continue;
                        if (x < lowestX) {
                            lowestX = x;
                        }
                        if (y >= lowestY) continue;
                        lowestY = y;
                    }
                }
                for (y = lowestY; y < cutout.getHeight(); ++y) {
                    for (x = lowestX; x < cutout.getWidth(); ++x) {
                        if ((cutout.getRGB(x, y) & 0xFF000000) == 0) continue;
                        img.setRGB(x - lowestX, y - lowestY, banner.getRGB(x, y));
                    }
                }
                int newWidth = (int)((double)elytra.getWidth() * 0.65625);
                for (int y2 = 0; y2 < img.getHeight(); ++y2) {
                    if ((img.getRGB(0, y2) & 0xFF000000) == 0) continue;
                    img.setRGB(0, y2, img.getRGB(newWidth - 1, y2));
                }
                for (x = 0; x < img.getWidth(); ++x) {
                    img.setRGB(x, 1, 0);
                    img.setRGB(x, 2, 0);
                    img.setRGB(x, 3, 0);
                }
                BufferedImage complete = new BufferedImage(newWidth, (int)((double)elytra.getHeight() * 1.5), img.getType());
                cg2d = complete.createGraphics();
                cg2d.drawImage((Image)img, 0, 0, null);
                cg2d.dispose();
                TextureUtil.func_110987_a((int)this.func_110552_b(), (BufferedImage)complete);
            }
        }
    }
}

