/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.util;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.api.util.FluxRiftReconstructor;

public final class RiftHelper {
    private RiftHelper() {
    }

    public static Vec3d getRiftCenter(EntityFluxRift rift) {
        return (Vec3d)rift.points.get(rift.points.size() / 2);
    }

    public static Vec3d getRiftCenter(FluxRiftReconstructor rift) {
        return rift.getPoints()[rift.getPoints().length / 2];
    }

    public static Vec3d pickRandomPointOnRift(EntityFluxRift rift) {
        return (Vec3d)rift.points.get(ThreadLocalRandom.current().nextInt(rift.points.size()));
    }

    public static Vec3d pickRandomPointOnRift(FluxRiftReconstructor rift) {
        return rift.getPoints()[ThreadLocalRandom.current().nextInt(rift.getPoints().length)];
    }

    public static Vec3d pickRandomPointOnRiftWithInstability(EntityFluxRift rift, int ticks) {
        int index = ThreadLocalRandom.current().nextInt(rift.points.size());
        Vec3d point = (Vec3d)rift.points.get(index);
        float time = (float)ticks + Minecraft.func_71410_x().func_184121_ak();
        if (index > rift.points.size() / 2) {
            time -= (float)(index * 10);
        } else if (index < rift.points.size() / 2) {
            time += (float)(index * 10);
        }
        float stab = Math.max(Math.min(1.0f - rift.getRiftStability() / 50.0f, 1.5f), 0.0f);
        return point.func_72441_c(Math.sin((double)time / 50.0) * (double)0.1f * (double)stab, Math.sin((double)time / 60.0) * (double)0.1f * (double)stab, Math.sin((double)time / 70.0) * (double)0.1f * (double)stab);
    }

    public static Vec3d pickRandomPointOnRiftWithInstability(EntityFluxRift rift, int ticks, float partialTicks) {
        int index = ThreadLocalRandom.current().nextInt(rift.points.size());
        Vec3d point = (Vec3d)rift.points.get(index);
        float time = (float)ticks + partialTicks;
        if (index > rift.points.size() / 2) {
            time -= (float)(index * 10);
        } else if (index < rift.points.size() / 2) {
            time += (float)(index * 10);
        }
        float stab = Math.max(Math.min(1.0f - rift.getRiftStability() / 50.0f, 1.5f), 0.0f);
        return point.func_72441_c(Math.sin((double)time / 50.0) * (double)0.1f * (double)stab, Math.sin((double)time / 60.0) * (double)0.1f * (double)stab, Math.sin((double)time / 70.0) * (double)0.1f * (double)stab);
    }

    public static Vec3d pickRandomPointOnRiftWithInstability(FluxRiftReconstructor rift, float stability, int ticks, float partialTicks) {
        int index = ThreadLocalRandom.current().nextInt(rift.points.length);
        Vec3d point = rift.points[index];
        float time = (float)ticks + partialTicks;
        if (index > rift.points.length / 2) {
            time -= (float)(index * 10);
        } else if (index < rift.points.length / 2) {
            time += (float)(index * 10);
        }
        float stab = Math.max(Math.min(1.0f - stability / 50.0f, 1.5f), 0.0f);
        return point.func_72441_c(Math.sin((double)time / 50.0) * (double)0.1f * (double)stab, Math.sin((double)time / 60.0) * (double)0.1f * (double)stab, Math.sin((double)time / 70.0) * (double)0.1f * (double)stab);
    }
}

