/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus.node.prefab;

import net.minecraft.util.math.BlockPos;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.node.ConsumeResult;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusConsumer;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusProvider;
import thecodex6824.thaumicaugmentation.api.impetus.node.NodeHelper;
import thecodex6824.thaumicaugmentation.api.impetus.node.prefab.ImpetusNode;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class BufferedImpetusProsumer
extends ImpetusNode
implements IImpetusProvider,
IImpetusConsumer {
    protected IImpetusStorage buffer;

    public BufferedImpetusProsumer(int totalInputs, int totalOutputs, IImpetusStorage owning) {
        this(totalInputs, totalOutputs, new DimensionalBlockPos(new BlockPos(0, 0, 0), 0), owning);
    }

    public BufferedImpetusProsumer(int totalInputs, int totalOutputs, DimensionalBlockPos location, IImpetusStorage storage) {
        super(totalInputs, totalOutputs, location);
        this.buffer = storage;
    }

    @Override
    public long provide(long energy, boolean simulate) {
        return this.buffer.extractEnergy(energy, simulate);
    }

    @Override
    public ConsumeResult consume(long amount, boolean simulate) {
        amount = Math.min(amount, this.buffer.receiveEnergy(Long.MAX_VALUE, true));
        ConsumeResult pair = NodeHelper.consumeImpetusFromConnectedProviders(amount, this, simulate);
        return new ConsumeResult(this.buffer.receiveEnergy(pair.energyConsumed, simulate), pair.paths);
    }

    public IImpetusStorage getProsumer() {
        return this.buffer;
    }
}

