/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.config;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import thecodex6824.thaumicaugmentation.api.config.ConfigOption;

public class ConfigOptionStringToIntMap
extends ConfigOption<Map<String, Integer>> {
    protected ImmutableMap<String, Integer> value;

    public ConfigOptionStringToIntMap(boolean enforceServer, Map<String, Integer> map) {
        super(enforceServer);
        this.value = ImmutableMap.copyOf(map);
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.value.size());
        this.value.forEach((k, v) -> {
            byte[] data = k.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(data.length);
            buf.writeBytes(data);
            buf.writeInt(v.intValue());
        });
    }

    @Override
    public void deserialize(ByteBuf buf) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int entries = buf.readInt();
        for (int i = 0; i < entries; ++i) {
            byte[] name = new byte[Math.min(buf.readInt(), 0x200000)];
            buf.readBytes(name);
            builder.put((Object)new String(name, StandardCharsets.UTF_8), (Object)buf.readInt());
        }
        this.value = builder.build();
    }

    @Override
    public Map<String, Integer> getValue() {
        return this.value;
    }

    @Override
    public void setValue(Map<String, Integer> value) {
        this.value = ImmutableMap.copyOf(value);
    }
}

