/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.ITileDroppable;
import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.FrictionRotator;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.init.ItemsTAR;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileEntitySummoner
extends TileSyncableTickable
implements IAspectContainer,
ITileDroppable {
    public final IntList entities = new IntArrayList();
    public final FrictionRotator rotator = new FrictionRotator();
    public ItemStack sample = ItemStack.field_190927_a;
    public AspectList accumulated = new AspectList();
    public AspectList missing = new AspectList();
    public int cooldown = 0;
    private Entity cachedEntity;

    public static AspectList getAspectsForDNA(ItemStack sample) {
        if (!sample.func_190926_b() && sample.func_77973_b() == ItemsTAR.ENTITY_CELL && sample.func_77942_o() && sample.func_77978_p().func_150297_b("Entity", 10)) {
            NBTTagCompound nbt = sample.func_77978_p().func_74775_l("Entity");
            EntityEntry entry = (EntityEntry)GameRegistry.findRegistry(EntityEntry.class).getValue(new ResourceLocation(nbt.func_74779_i("Id")));
            NBTTagCompound tc = nbt.func_74775_l("Data");
            AspectList tags = new AspectList();
            if (entry != null) {
                for (ThaumcraftApi.EntityTags et : CommonInternals.scanEntities) {
                    if (!et.entityName.equals(entry.getName())) continue;
                    if (et.nbts == null || et.nbts.length == 0) {
                        tags = et.aspects;
                        continue;
                    }
                    for (ThaumcraftApi.EntityTagsNBT enbt : et.nbts) {
                        if (tc.func_74764_b(enbt.name) && ThaumcraftApiHelper.getNBTDataFromId((NBTTagCompound)tc, (byte)tc.func_150299_b(enbt.name), (String)enbt.name).equals(enbt.value)) continue;
                    }
                    tags.add(et.aspects);
                }
            }
            return tags;
        }
        return new AspectList();
    }

    public static FrictionRotator readFrictionRotatorFromNBT(NBTTagCompound nbt, FrictionRotator rotator) {
        rotator.currentSpeed = nbt.func_74760_g("CurrentSpeed");
        rotator.degree = nbt.func_74760_g("Degree");
        rotator.friction = nbt.func_74760_g("Friction");
        rotator.prevDegree = nbt.func_74760_g("PrevDegree");
        rotator.speed = nbt.func_74760_g("Speed");
        return rotator;
    }

    public static NBTTagCompound writeFrictionRotatorToNBT(FrictionRotator rotator, NBTTagCompound nbt) {
        nbt.func_74776_a("CurrentSpeed", rotator.currentSpeed);
        nbt.func_74776_a("Degree", rotator.degree);
        nbt.func_74776_a("Friction", rotator.friction);
        nbt.func_74776_a("PrevDegree", rotator.prevDegree);
        nbt.func_74776_a("Speed", rotator.speed);
        return nbt;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getCachedEntity() {
        boolean cs = this.canSpawn();
        if (this.cachedEntity == null && cs) {
            String id = this.sample.func_77978_p().func_74775_l("Entity").func_74779_i("Id");
            this.cachedEntity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(id), (World)this.field_145850_b);
            if (this.cachedEntity instanceof EntityLiving) {
                ((EntityLiving)this.cachedEntity).func_180482_a(this.field_145850_b.func_175649_E(new BlockPos(this.cachedEntity)), null);
            }
        }
        if (!cs) {
            this.cachedEntity = null;
        }
        return this.cachedEntity;
    }

    public void tick() {
        this.rotator.friction = 0.25f;
        this.rotator.update();
        this.entities.removeIf(e -> this.field_145850_b.func_73045_a(e.intValue()) == null || this.field_145850_b.func_73045_a((int)e.intValue()).field_70128_L);
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.accumulated == null) {
            this.accumulated = new AspectList();
        }
        AspectList requirements = null;
        this.rotator.speedup(0.2f);
        if (this.canSpawn() && (requirements = TileEntitySummoner.getAspectsForDNA(this.sample)).visSize() > 0) {
            Aspect[] as;
            Aspect a;
            this.missing = AspectUtil.getMissing(this.accumulated, requirements);
            if (this.missing.visSize() == 0) {
                if (this.cooldown == 0 && !this.field_145850_b.field_72995_K && this.atTickRate(20) && this.performSpawn()) {
                    this.cooldown += 80 + this.getRNG().nextInt(50);
                    this.accumulated.remove(requirements);
                    this.rotator.speedup(10.0f);
                    this.sendChangesToNearby();
                }
            } else if (!this.field_145850_b.field_72995_K && this.missing != null && this.missing.size() > 0 && this.atTickRate(3) && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)(a = (as = this.missing.getAspects())[as.length - 1]), null, (int)8, (int)1)) {
                this.accumulated.add(a, 1);
                this.rotator.speedup(1.0f);
                this.sendChangesToNearby();
            }
        } else {
            this.missing = new AspectList();
        }
    }

    public void createDrop(EntityPlayer player, World world, BlockPos pos) {
        if (!this.sample.func_190926_b()) {
            WorldUtil.spawnItemStack((World)world, (BlockPos)pos, (ItemStack)this.sample);
        }
        AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)this.accumulated.visSize(), (boolean)true);
    }

    public boolean performSpawn() {
        int spawnCount = 1 + this.getRNG().nextInt(4);
        double spawnRange = 4.0;
        int maxNearbyEntities = 4;
        int spawned = 0;
        for (int i = 0; i < spawnCount && this.entities.size() < 10; ++i) {
            String id = this.sample.func_77978_p().func_74775_l("Entity").func_74779_i("Id");
            double d0 = (double)this.field_174879_c.func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * spawnRange + 0.5;
            double d1 = this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3);
            double d2 = (double)this.field_174879_c.func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * spawnRange + 0.5;
            Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(id), (World)this.field_145850_b);
            if (entity == null) {
                return false;
            }
            entity.func_70634_a(d0, d1, d2);
            WorldServer ws = (WorldServer)Cast.cast((Object)this.field_145850_b, WorldServer.class);
            for (int k = 0; k < 16 && ws != null && ws.func_175733_a(entity.func_110124_au()) != null; ++k) {
                entity.func_184221_a(UUID.randomUUID());
            }
            EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entityliving != null) {
                entityliving.func_70656_aK();
            }
            if (this.field_145850_b.field_72995_K) continue;
            AnvilChunkLoader.func_186052_a((Entity)entity, (World)this.field_145850_b);
            this.entities.add(entity.func_145782_y());
            ++spawned;
        }
        if (spawned > 0) {
            this.field_145850_b.func_175718_b(2004, this.field_174879_c, 0);
        }
        return spawned > 0;
    }

    public boolean canSpawn() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return false;
        }
        return !this.sample.func_190926_b() && this.sample.func_77973_b() == ItemsTAR.ENTITY_CELL && this.sample.func_77942_o() && this.sample.func_77978_p().func_150297_b("Entity", 10);
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Accum", (NBTBase)AspectUtil.writeALToNBT(this.accumulated, new NBTTagCompound()));
        nbt.func_74782_a("Sample", (NBTBase)this.sample.serializeNBT());
        nbt.func_74768_a("Cooldown", this.cooldown);
        nbt.func_74782_a("Rotator", (NBTBase)TileEntitySummoner.writeFrictionRotatorToNBT(this.rotator, new NBTTagCompound()));
    }

    public void readNBT(NBTTagCompound nbt) {
        TileEntitySummoner.readFrictionRotatorFromNBT(nbt.func_74775_l("Rotator"), this.rotator);
        this.cooldown = nbt.func_74762_e("Cooldown");
        this.accumulated = new AspectList();
        if (nbt.func_74764_b("Accum")) {
            this.accumulated.readFromNBT(nbt.func_74775_l("Accum"));
        }
        this.sample = new ItemStack(nbt.func_74775_l("Sample"));
    }

    public AspectList getAspects() {
        return this.missing != null && this.missing.size() > 0 ? this.missing : null;
    }

    public void setAspects(AspectList var1) {
    }

    public boolean doesContainerAccept(Aspect var1) {
        return false;
    }

    public int addToContainer(Aspect a, int q) {
        if (this.missing != null) {
            int max = Math.min(this.missing.getAmount(a), q);
            if (this.accumulated != null) {
                this.accumulated.add(a, max);
                return max;
            }
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect var1, int var2) {
        return false;
    }

    public boolean takeFromContainer(AspectList var1) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect var1, int var2) {
        return false;
    }

    public boolean doesContainerContain(AspectList var1) {
        return false;
    }

    public int containerContains(Aspect var1) {
        return 0;
    }
}

