/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.FrictionRotator;
import com.zeitheron.hammercore.utils.inventory.InventoryDummy;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import org.zeith.thaumicadditions.api.fx.ParticleHelperTAR;
import org.zeith.thaumicadditions.init.ItemsTAR;
import org.zeith.thaumicadditions.inventory.container.ContainerCrystalCrusher;
import org.zeith.thaumicadditions.inventory.gui.GuiCrystalCrusher;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.lib.events.EssentiaHandler;

public class TileCrystalCrusher
extends TileSyncableTickable
implements ISidedInventory {
    public final FrictionRotator rotator = new FrictionRotator();
    private final int[] slots = new int[]{0, 1};
    public InventoryDummy inv = new InventoryDummy(2);
    public int crushes;
    public int craftTime;

    public TileCrystalCrusher() {
        this.rotator.degree = new Random().nextFloat() * 360.0f;
    }

    public void tick() {
        this.rotator.friction = 0.5f;
        if (this.field_145850_b.field_72995_K) {
            this.rotator.update();
        }
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0) {
            return;
        }
        if (this.crushes <= 0 && EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.MECHANISM, null, (int)12, (int)1)) {
            this.crushes += 3;
        }
        if (this.canCraft()) {
            ++this.craftTime;
            if (this.field_145850_b.field_72995_K) {
                this.rotator.speedup(1.0f);
                ParticleHelperTAR.spawnItemCrack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.1 + (double)this.getRNG().nextFloat() * 0.8, (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p() + 0.1 + (double)this.getRNG().nextFloat() * 0.8, (double)(this.getRNG().nextFloat() - this.getRNG().nextFloat()) * 0.3, 0.0, (double)(this.getRNG().nextFloat() - this.getRNG().nextFloat()) * 0.3, this.inv.func_70301_a(0));
            }
            if (!this.field_145850_b.field_72995_K && this.atTickRate(10)) {
                this.sendChangesToNearby();
            }
            if (!this.field_145850_b.field_72995_K && this.craftTime >= 100) {
                this.craft();
            }
        } else if (this.craftTime > 0) {
            --this.craftTime;
        }
    }

    public boolean canCraft() {
        ItemStack in = this.inv.func_70301_a(0);
        ItemStack out = this.inv.func_70301_a(1);
        if (this.crushes <= 0) {
            return false;
        }
        if (in.func_190926_b() || in.func_77973_b() != ItemsTC.crystalEssence) {
            return false;
        }
        return out.func_190926_b() || out.func_77973_b() == ItemsTAR.SALT_ESSENCE && Objects.equals(in.func_77978_p(), out.func_77978_p());
    }

    public void craft() {
        NBTTagCompound nbt = this.inv.func_70301_a(0).func_77978_p();
        if (nbt != null) {
            nbt = nbt.func_74737_b();
        }
        if (this.inv.func_70301_a(1).func_190926_b()) {
            this.inv.func_70301_a(0).func_190918_g(1);
            ItemStack stack = new ItemStack((Item)ItemsTAR.SALT_ESSENCE);
            stack.func_77982_d(nbt);
            this.inv.func_70299_a(1, stack);
            --this.crushes;
        } else if (this.inv.func_70301_a(1).func_77973_b() == ItemsTAR.SALT_ESSENCE && Objects.equals(this.inv.func_70301_a(0).func_77978_p(), this.inv.func_70301_a(1).func_77978_p())) {
            this.inv.func_70301_a(0).func_190918_g(1);
            this.inv.func_70301_a(1).func_190917_f(1);
            --this.crushes;
        }
        this.craftTime = 0;
        this.sync();
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Fuel", this.crushes);
        nbt.func_74768_a("CraftTime", this.craftTime);
        nbt.func_74782_a("Items", (NBTBase)this.inv.writeToNBT(new NBTTagCompound()));
    }

    public void readNBT(NBTTagCompound nbt) {
        this.crushes = nbt.func_74762_e("Fuel");
        this.craftTime = nbt.func_74762_e("CraftTime");
        this.inv.readFromNBT(nbt.func_74775_l("Items"));
    }

    public boolean hasGui() {
        return true;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiCrystalCrusher(player, this);
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerCrystalCrusher(player, this);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inv.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inv.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inv.isUsableByPlayer(player, this.field_174879_c);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() == ItemsTC.crystalEssence;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }
}

