/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.tiles;

import com.zeitheron.hammercore.tile.TileSyncableTickable;
import com.zeitheron.hammercore.utils.FrictionRotator;
import com.zeitheron.hammercore.utils.ItemStackUtil;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.WorldLocation;
import com.zeitheron.hammercore.utils.WorldUtil;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.zeith.thaumicadditions.api.AspectUtil;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.world.ore.BlockCrystal;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.world.aura.AuraHandler;

public class TileCrystalBore
extends TileSyncableTickable {
    public final FrictionRotator rotator = new FrictionRotator();
    public int minCrystals = 1;
    public EnumFacing face;
    public EnumFacing oldFace;
    public int boring = 0;

    public TileCrystalBore() {
        this.rotator.degree = new Random().nextFloat() * 360.0f;
    }

    public void tick() {
        this.rotator.friction = 0.25f;
        this.rotator.update();
        this.oldFace = this.face;
        this.face = WorldUtil.getFacing((IBlockState)this.loc.getState());
        if (this.canBore()) {
            boolean isDraneable;
            boolean bl = isDraneable = AuraHandler.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)1.0f, (boolean)true) >= 0.02f;
            if (isDraneable) {
                ++this.boring;
                this.rotator.speedup(0.5f);
                AuraHandler.drainVis((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)0.02f, (boolean)false);
                if (this.field_145850_b.field_72995_K && this.atTickRate(3)) {
                    int i = 4;
                    double j = 0.8;
                    for (int a = 0; a < i; ++a) {
                        double x = (double)this.func_174877_v().func_177958_n() - (double)this.face.func_82601_c() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        double y = (double)this.func_174877_v().func_177956_o() - (double)this.face.func_96559_d() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        double z = (double)this.func_174877_v().func_177952_p() - (double)this.face.func_82599_e() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        FXDispatcher.INSTANCE.drawCurlyWisp(x + (double)this.face.func_82601_c() / 2.0, y + (double)this.face.func_96559_d() / 2.0, z + (double)this.face.func_82599_e() / 2.0, (double)this.face.func_82601_c() / 25.0 * j + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, (double)this.face.func_96559_d() / 25.0 * j + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, (double)this.face.func_82599_e() / 25.0 * j + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.0033f, 0.5f, 0.25f, 0.75f, 1.0f, 0.25f, null, 1, 0, a % 3 * 2);
                        x = (double)this.func_174877_v().func_177958_n() - (double)this.face.func_82601_c() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        y = (double)this.func_174877_v().func_177956_o() - (double)this.face.func_96559_d() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        z = (double)this.func_174877_v().func_177952_p() - (double)this.face.func_82599_e() / 1.6 + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.025f;
                        FXDispatcher.INSTANCE.drawCurlyWisp(x, y, z, (double)((float)this.face.func_82601_c() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, (double)((float)this.face.func_96559_d() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, (double)((float)this.face.func_82599_e() / 25.0f * (float)j) + this.field_145850_b.field_73012_v.nextGaussian() * (double)0.002f, 0.25f, this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), this.field_145850_b.field_73012_v.nextFloat(), 0.5f, null, 1, 0, 1 + a % 3 * 2);
                    }
                    if (this.atTickRate(3)) {
                        SoundUtil.playSoundEffect((WorldLocation)this.loc, (String)"thaumcraft:grind", (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.BLOCKS);
                    }
                }
            }
            if (this.boring >= 100) {
                EnumFacing of;
                BlockPos opos;
                this.boring = 0;
                ItemStack bored = this.bore();
                if (!bored.func_190926_b() && !(bored = ItemStackUtil.inject((ItemStack)bored, (TileEntity)this.field_145850_b.func_175625_s(opos = this.field_174879_c.func_177972_a(of = this.face.func_176734_d())), (EnumFacing)this.face)).func_190926_b()) {
                    Random rand = this.field_145850_b.field_73012_v;
                    if (!this.field_145850_b.field_72995_K) {
                        EntityItem ei = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)of.func_82601_c() * 0.6, (double)this.field_174879_c.func_177956_o() + 0.5 + (double)of.func_96559_d() * 0.6, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)of.func_82599_e() * 0.6, bored.func_77946_l());
                        ei.field_70159_w = (double)of.func_82601_c() * rand.nextDouble() * 0.35;
                        ei.field_70181_x = (double)of.func_96559_d() * rand.nextDouble() * 0.35;
                        ei.field_70179_y = (double)of.func_82599_e() * rand.nextDouble() * 0.35;
                        this.field_145850_b.func_72838_d((Entity)ei);
                    }
                }
                this.sendChangesToNearby();
            }
        }
    }

    public boolean canBore() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.face));
        return this.getLocation().getRedstone() == 0 && state.func_177230_c() instanceof BlockCrystal && (Integer)state.func_177229_b((IProperty)BlockCrystal.SIZE) >= this.minCrystals;
    }

    public ItemStack bore() {
        int co;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.face));
        if (state.func_177230_c() instanceof BlockCrystal && (co = ((Integer)state.func_177229_b((IProperty)BlockCrystal.SIZE)).intValue()) >= this.minCrystals - 1) {
            state = state.func_177226_a((IProperty)BlockCrystal.SIZE, (Comparable)Integer.valueOf(co - 1));
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(this.face), state);
            if (!this.field_145850_b.field_72995_K) {
                SoundUtil.playSoundEffect((World)this.field_145850_b, (String)SoundsTC.crystal.getRegistryName().toString(), (BlockPos)this.field_174879_c, (float)0.3f, (float)0.8f, (SoundCategory)SoundCategory.BLOCKS);
            }
            return AspectUtil.crystalEssence(((BlockCrystal)state.func_177230_c()).aspect);
        }
        return ItemStack.field_190927_a;
    }

    public void writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("MinCrystals", this.minCrystals);
    }

    public void readNBT(NBTTagCompound nbt) {
        this.minCrystals = nbt.func_74762_e("MinCrystals");
    }
}

