/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.seals.woid;

import com.zeitheron.hammercore.utils.ItemStackUtil;
import com.zeitheron.hammercore.utils.WorldLocation;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.zeith.thaumicadditions.api.seals.SealInstance;
import org.zeith.thaumicadditions.tiles.TileSeal;
import org.zeith.thaumicadditions.utils.ThaumicMath;

public class SealPickup
extends SealInstance {
    public SealPickup(TileSeal seal) {
        super(seal);
    }

    @Override
    public void tick() {
        if (!this.seal.atTickRate(3)) {
            return;
        }
        WorldLocation loc = this.seal.getLocation();
        Random rand = loc.getWorld().field_73012_v;
        if (loc.getRedstone() > 0) {
            return;
        }
        EnumFacing to = this.seal.orientation;
        EnumFacing from = to.func_176734_d();
        float mult = 0.7f;
        float modX = (rand.nextFloat() - rand.nextFloat()) * 0.5f;
        float modY = (rand.nextFloat() - rand.nextFloat()) * 0.5f;
        float modZ = (rand.nextFloat() - rand.nextFloat()) * 0.5f;
        Vec3d pos = new Vec3d((Vec3i)loc.getPos()).func_72441_c(0.5, 0.5, 0.5);
        BlockPos center0 = loc.getPos().func_177967_a(to, 4);
        if (to.func_176740_k() == EnumFacing.Axis.Y) {
            center0 = loc.getPos().func_177967_a(to, to == EnumFacing.UP ? 2 : 4);
        }
        AxisAlignedBB suck = new AxisAlignedBB(center0).func_72314_b(5.0, 3.0, 5.0);
        List drops = loc.getWorld().func_72872_a(EntityItem.class, suck);
        for (EntityItem ei : drops) {
            double moveX = ThaumicMath.cap((pos.field_72450_a - ei.field_70165_t) / 30.0, 0.025);
            double moveY = ThaumicMath.cap((pos.field_72448_b - ei.field_70163_u) / 30.0, 0.025);
            double moveZ = ThaumicMath.cap((pos.field_72449_c - ei.field_70161_v) / 30.0, 0.025);
            ei.func_189654_d(true);
            ei.field_70159_w = moveX;
            ei.field_70181_x = moveY;
            ei.field_70179_y = moveZ;
        }
    }

    @Override
    public void onEntityCollisionWithSeal(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityItem && this.seal.getLocation().getRedstone() <= 0) {
            BlockPos rock = this.seal.func_174877_v().func_177972_a(this.seal.orientation.func_176734_d());
            for (EnumFacing face : EnumFacing.field_82609_l) {
                ItemStack it = ((EntityItem)entityIn).func_92059_d();
                if (it.func_190926_b()) {
                    entityIn.func_70106_y();
                    return;
                }
                TileEntity tile = worldIn.func_175625_s(rock.func_177972_a(face));
                it = ItemStackUtil.inject((ItemStack)it, (TileEntity)tile, (EnumFacing)face.func_176734_d());
                ((EntityItem)entityIn).func_92058_a(it);
                if (!it.func_190926_b()) continue;
                entityIn.func_70106_y();
                return;
            }
        }
    }
}

