/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.zeith.thaumicadditions.init.BlocksTAR;

public class RecipePaintSeal
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);

    public RecipePaintSeal() {
        this.setRegistryName(new ResourceLocation("thaumadditions", "seal_paint"));
    }

    private static float[] createSheepColor(EnumDyeColor p_192020_0_) {
        float[] afloat = p_192020_0_.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack itemstack = ItemStack.field_190927_a;
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        Item itemseal = null;
        for (int k = 0; k < inv.func_70302_i_(); ++k) {
            ItemStack itemstack1 = inv.func_70301_a(k);
            if (itemstack1.func_190926_b()) continue;
            if (itemstack1.func_77973_b() == Item.func_150898_a((Block)BlocksTAR.SEAL)) {
                itemseal = Item.func_150898_a((Block)BlocksTAR.SEAL);
                itemstack = itemstack1.func_77946_l();
                itemstack.func_190920_e(1);
                if (!itemstack1.func_77942_o() || !itemstack1.func_77978_p().func_150297_b("RGB", 11)) continue;
                int[] rgb = itemstack1.func_77978_p().func_74759_k("RGB");
                int l = rgb[0] << 16 | rgb[1] << 8 | rgb[2] << 0;
                float f = (float)(l >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(l >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(l & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
                aint[0] = (int)((float)aint[0] + f * 255.0f);
                aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                ++j;
                continue;
            }
            if (itemstack1.func_77973_b() != Items.field_151100_aR) {
                return ItemStack.field_190927_a;
            }
            float[] afloat = RecipePaintSeal.getDyeRgb(EnumDyeColor.func_176766_a((int)itemstack1.func_77960_j()));
            int l1 = (int)(afloat[0] * 255.0f);
            int i2 = (int)(afloat[1] * 255.0f);
            int j2 = (int)(afloat[2] * 255.0f);
            i += Math.max(l1, Math.max(i2, j2));
            aint[0] = aint[0] + l1;
            aint[1] = aint[1] + i2;
            aint[2] = aint[2] + j2;
            ++j;
        }
        if (itemseal == null) {
            return ItemStack.field_190927_a;
        }
        int i1 = aint[0] / j;
        int j1 = aint[1] / j;
        int k1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(i1, Math.max(j1, k1));
        i1 = (int)((float)i1 * f3 / f4);
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        int col = (i1 << 8) + j1;
        col = (col << 8) + k1;
        NBTTagCompound nbt = itemstack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74783_a("RGB", new int[]{col >> 16 & 0xFF, col >> 8 & 0xFF, col >> 0 & 0xFF});
        itemstack.func_77982_d(nbt);
        return itemstack;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemStack itemstack = ItemStack.field_190927_a;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack itemstack1 = inv.func_70301_a(i);
            if (itemstack1.func_190926_b()) continue;
            if (itemstack1.func_77973_b() == Item.func_150898_a((Block)BlocksTAR.SEAL)) {
                if (!itemstack.func_190926_b()) {
                    return false;
                }
                itemstack = itemstack1;
                continue;
            }
            if (itemstack1.func_77973_b() != Items.field_151100_aR) {
                return false;
            }
            list.add(itemstack1);
        }
        return !itemstack.func_190926_b() && !list.isEmpty();
    }

    static {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            DYE_TO_RGB.put(enumdyecolor, RecipePaintSeal.createSheepColor(enumdyecolor));
        }
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{0.9019608f, 0.9019608f, 0.9019608f});
    }
}

