/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.items.seed;

import com.zeitheron.hammercore.utils.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.blocks.plants.BlockVisCrop;
import org.zeith.thaumicadditions.init.BlocksTAR;
import org.zeith.thaumicadditions.init.ItemsTAR;
import org.zeith.thaumicadditions.items.placeholder.ItemVisSeedsNew;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ItemVisSeeds
extends ItemSeeds
implements IEssentiaContainerItem {
    public static final int ASPECT_COUNT = 2;

    public ItemVisSeeds() {
        super(null, Blocks.field_150458_ak);
        this.func_77655_b("vis_seeds");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        BlockVisCrop crop;
        Aspect a = ItemVisSeeds.fromSeed(stack);
        if (a != null && (crop = BlocksTAR.VIS_CROPS.get(a)) != null) {
            Field itemRaw = ReflectionUtil.getFieldByValue(ItemStack.class, (Object)stack, (Object)stack.func_77973_b());
            Field delegate = ReflectionUtil.getFieldByValue(ItemStack.class, (Object)stack, (Object)stack.func_77973_b().delegate);
            try {
                ReflectionUtil.setFinalField((Field)itemRaw, (Object)stack, (Object)((Object)crop.seed));
                ReflectionUtil.setFinalField((Field)delegate, (Object)stack, (Object)crop.seed.delegate);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static int getColor(ItemStack stack, int layer) {
        Aspect a;
        if (layer == 1 && (a = ItemVisSeeds.fromSeed(stack)) != null) {
            return a.getColor();
        }
        return 0xFFFFFF;
    }

    public static Aspect fromSeed(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemVisSeedsNew) {
            return ((ItemVisSeedsNew)stack.func_77973_b()).getAspect();
        }
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Aspect", 8)) {
            return Aspect.getAspect((String)stack.func_77978_p().func_74779_i("Aspect"));
        }
        return null;
    }

    public static ItemStack create(Aspect aspect, int count) {
        return Optional.ofNullable(BlocksTAR.VIS_CROPS.get(aspect)).map(c -> new ItemStack((Item)c.seed)).orElseGet(() -> {
            ItemStack stack = new ItemStack((Item)ItemsTAR.VIS_SEEDS, count);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a("Aspect", aspect.getTag());
            return stack;
        });
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Aspect asp = ItemVisSeeds.fromSeed(stack);
        IBlockState crop = asp != null && BlocksTAR.VIS_CROPS.containsKey(asp) ? BlocksTAR.VIS_CROPS.get(asp).func_176223_P() : null;
        IBlockState state = worldIn.func_180495_p(pos);
        if (facing == EnumFacing.UP && player.func_175151_a(pos.func_177972_a(facing), facing, stack) && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this) && worldIn.func_175623_d(pos.func_177984_a()) && asp != null && crop != null) {
            worldIn.func_175656_a(pos.func_177984_a(), crop);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos.func_177984_a(), stack);
            }
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        Block crop = (Block)BlocksTAR.VIS_CROPS.get(AspectUtil.cycleRandomAspect(BlocksTAR.INDEXED_ASPECTS));
        if (crop == null) {
            crop = Blocks.field_150350_a;
        }
        return crop.func_176223_P();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Aspect a : BlocksTAR.VIS_CROPS.keySet()) {
                items.add((Object)ItemVisSeeds.create(a, 1));
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        String an = "Unknown";
        Aspect a = ItemVisSeeds.fromSeed(stack);
        if (a != null) {
            an = a.getName();
        }
        return I18n.func_74837_a((String)(this.func_77657_g(stack) + ".name"), (Object[])new Object[]{an}).trim();
    }

    public AspectList getAspects(ItemStack stack) {
        AspectList al = new AspectList();
        Aspect a = ItemVisSeeds.fromSeed(stack);
        if (a != null) {
            al.add(a, 2);
        }
        return al;
    }

    public boolean ignoreContainedAspects() {
        return false;
    }

    public void setAspects(ItemStack stack, AspectList list) {
        if (list.getAspects().length > 0) {
            Aspect a = list.getAspects()[0];
            int ac = list.getAmount(a) / 2;
            stack.func_190920_e(ac);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            stack.func_77978_p().func_74778_a("Aspect", a.getTag());
        }
    }
}

