/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.client.util;

import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class GLDownloader {
    public static BufferedImage toBufferedImage(ByteBuffer buffer, int width, int height, int channels) {
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i = (x + y * width) * channels;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                int a = 255;
                if (channels == 4) {
                    a = buffer.get(i + 3) & 0xFF;
                }
                image.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return image;
    }

    public static void toGL4(ByteBuffer buffer, int glTex, int width, int height) {
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }

    public static void toGL3(ByteBuffer buffer, int glTex, int width, int height) {
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)buffer);
    }

    public static ByteBuffer toByteBuffer(int glTex) {
        int format = GLDownloader.getFormat(glTex);
        int width = GLDownloader.getWidth(glTex);
        int height = GLDownloader.getHeight(glTex);
        int channels = GLDownloader.getChannels(format);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * channels));
        GL11.glGetTexImage((int)3553, (int)0, (int)format, (int)5121, (ByteBuffer)buffer);
        return buffer;
    }

    public static int getChannels(int format) {
        int channels = 4;
        if (format == 6407) {
            channels = 3;
        }
        return channels;
    }

    public static int getFormat(int glTex) {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
    }

    public static int getHeight(int glTex) {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
    }

    public static int getWidth(int glTex) {
        return GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
    }
}

