/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.client.render.entity;

import com.zeitheron.hammercore.lib.zlib.tuple.TwoTuple;
import java.util.function.BiConsumer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.zeith.thaumicadditions.client.models.ModelChester;
import org.zeith.thaumicadditions.entity.EntityChester;

@SideOnly(value=Side.CLIENT)
public class RenderChester
extends RenderLiving<EntityChester> {
    public static final ResourceLocation CHESTER_TEXTURE = new ResourceLocation("thaumadditions", "textures/models/chester.png");
    public static boolean visualsEnabled = false;
    public static BiConsumer<EntityChester, TwoTuple<Vec3d, Vec2f>> visualsRenderer = null;
    private final ModelChester trunkModel;

    public RenderChester(RenderManager renderManager) {
        this(renderManager, new ModelChester());
    }

    protected RenderChester(RenderManager renderManager, ModelChester model) {
        super(renderManager, (ModelBase)model, 0.01f);
        this.trunkModel = model;
    }

    protected void adjustTrunk(EntityChester entity, float f) {
        int i = 2;
        float f1 = (entity.field_767_b + (entity.field_768_a - entity.field_767_b) * f) / ((float)i * 0.5f + 1.0f);
        float f2 = 1.0f / (f1 + 1.0f);
        float f3 = i;
        f1 /= 1.5f;
        GL11.glScalef((float)((f2 /= 1.4f) * (f3 /= 1.5f)), (float)(0.5f / f2 * f3), (float)(f2 * f3));
        GL11.glTranslatef((float)-0.45f, (float)0.45f, (float)-0.45f);
        f1 = 1.0f - entity.getCurrentLidRotation(f);
        f1 = 0.0f;
        f1 = 1.0f - f1 * f1 * f1;
        this.trunkModel.chestLid.field_78795_f = -f1 * (float)Math.PI / 2.0f;
    }

    protected ResourceLocation getEntityTexture(EntityChester entity) {
        return CHESTER_TEXTURE;
    }

    protected void preRenderCallback(EntityChester entity, float partialTickTime) {
        int i = 2;
        float f1 = (entity.field_767_b + (entity.field_768_a - entity.field_767_b) * partialTickTime) / ((float)i * 0.5f + 1.0f);
        float f2 = 1.0f / (f1 + 1.0f);
        float f3 = i;
        f1 /= 1.5f;
        float lid = entity.getCurrentLidRotation(partialTickTime);
        GL11.glScalef((float)((f2 /= 1.4f) * (f3 /= 1.5f)), (float)(0.5f / f2 * f3), (float)(f2 * f3));
        GL11.glTranslatef((float)-0.45f, (float)0.45f, (float)-0.45f);
        f1 = 1.0f - lid;
        f1 = 1.0f - f1 * f1 * f1;
        this.trunkModel.chestLid.field_78795_f = -f1 * (float)Math.PI / 2.0f;
    }

    public void doRender(EntityChester entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (visualsRenderer != null) {
            visualsRenderer.accept(entity, (TwoTuple<Vec3d, Vec2f>)new TwoTuple((Object)new Vec3d(x, y, z), (Object)new Vec2f(entityYaw, partialTicks)));
        }
    }
}

