/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.blocks.decor;

import com.zeitheron.hammercore.internal.blocks.base.BlockDeviceHC;
import com.zeitheron.hammercore.internal.blocks.base.IBlockEnableable;
import com.zeitheron.hammercore.internal.blocks.base.IBlockHorizontal;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.tiles.TileCrystalLamp;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.resources.ItemCrystalEssence;
import thaumcraft.common.lib.SoundsTC;

public class BlockCrystalLamp
extends BlockDeviceHC<TileCrystalLamp>
implements IBlockHorizontal,
IBlockEnableable {
    public BlockCrystalLamp() {
        super(Material.field_151573_f, TileCrystalLamp.class, "crystal_lamp");
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("axe", 0);
    }

    public static int getColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        Aspect a;
        TileCrystalLamp tcb = (TileCrystalLamp)((Object)Cast.cast((Object)worldIn.func_175625_s(pos), TileCrystalLamp.class));
        if (tcb != null && (a = tcb.getAspect()) != null) {
            return a.getColor();
        }
        return 0xFFFFFF;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileCrystalLamp tile = (TileCrystalLamp)((Object)Cast.cast((Object)worldIn.func_175625_s(pos), TileCrystalLamp.class));
        if (tile == null || tile.getAspect() == null) {
            return state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)ENABLED) != false ? 12 : 0;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos frompos) {
        boolean enabled = (Boolean)state.func_177229_b((IProperty)ENABLED);
        TileCrystalLamp tile = (TileCrystalLamp)((Object)Cast.cast((Object)worldIn.func_175625_s(pos), TileCrystalLamp.class));
        boolean tp = tile != null && tile.getAspect() != null;
        boolean powered = !worldIn.func_175640_z(pos) && tp;
        state = state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(powered));
        BlockCrystalLamp.updateStateKeepTile((World)worldIn, (BlockPos)pos, (IBlockState)state);
        if (enabled != powered) {
            worldIn.func_175653_a(EnumSkyBlock.BLOCK, pos, this.getLightValue(state, (IBlockAccess)worldIn, pos));
            worldIn.func_175664_x(pos);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileCrystalLamp tile = (TileCrystalLamp)((Object)Cast.cast((Object)worldIn.func_175625_s(pos), TileCrystalLamp.class));
        if (tile != null) {
            Aspect asp;
            AspectList aspects;
            ItemStack held = playerIn.func_184586_b(hand);
            boolean flag = false;
            if (tile.getAspect() != null && playerIn.func_70093_af()) {
                if (!playerIn.func_184812_l_()) {
                    WorldUtil.spawnItemStack((World)worldIn, (BlockPos)pos, (ItemStack)AspectUtil.crystalEssence(tile.getAspect(), 1));
                }
                tile.setAspect(null);
                flag = true;
            }
            if (held.func_77973_b() == ItemsTC.crystalEssence && (aspects = ((ItemCrystalEssence)ItemsTC.crystalEssence).getAspects(held)).getAspects().length == 1 && (asp = aspects.getAspects()[0]) != null) {
                Aspect prev = tile.setAspect(asp);
                if (!playerIn.func_184812_l_()) {
                    if (prev != null) {
                        WorldUtil.spawnItemStack((World)worldIn, (BlockPos)pos, (ItemStack)AspectUtil.crystalEssence(prev, 1));
                    }
                    held.func_190918_g(1);
                }
                flag = true;
            }
            if (flag) {
                worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.crystal, SoundCategory.BLOCKS, 0.5f, 0.4f / (playerIn.func_70681_au().nextFloat() * 0.4f + 0.8f));
                BlockCrystalLamp.updateStateKeepTile((World)worldIn, (BlockPos)pos, (IBlockState)this.func_176221_a(state.func_177226_a((IProperty)ENABLED, (Comparable)Boolean.valueOf(true)), (IBlockAccess)worldIn, pos));
            }
            return flag;
        }
        return false;
    }
}

