/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.blocks;

import com.zeitheron.hammercore.internal.blocks.IItemBlock;
import com.zeitheron.hammercore.internal.blocks.base.BlockTileHC;
import com.zeitheron.hammercore.utils.SoundUtil;
import com.zeitheron.hammercore.utils.base.Cast;
import com.zeitheron.hammercore.utils.color.ColorHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.zeith.thaumicadditions.api.AspectUtil;
import org.zeith.thaumicadditions.api.items.EssentiaJarManager;
import org.zeith.thaumicadditions.tiles.TileAbstractJarFillable;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.blocks.ILabelable;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.tiles.essentia.TileAlembic;

public class BlockAbstractEssentiaJar<T extends TileAbstractJarFillable>
extends BlockTileHC<T>
implements ILabelable,
IItemBlock {
    public static boolean spillEssentia;
    public final int capacity;
    public final BlockAbstractJarItem itemBlock = new BlockAbstractJarItem(this);

    public BlockAbstractEssentiaJar(Class<T> t, int capacity, String name) {
        super(Material.field_151592_s, t, name);
        this.capacity = capacity;
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundsTC.JAR);
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileAbstractJarFillable te = (TileAbstractJarFillable)((Object)Cast.cast((Object)world.func_175625_s(pos), TileAbstractJarFillable.class));
        if (te != null) {
            ItemStack drop = new ItemStack((Block)this, 1);
            if (te.amount > 0) {
                ((BlockAbstractJarItem)drop.func_77973_b()).setAspects(drop, new AspectList().add(te.aspect, te.amount));
            }
            if (te.aspectFilter != null) {
                if (!drop.func_77942_o()) {
                    drop.func_77982_d(new NBTTagCompound());
                }
                drop.func_77978_p().func_74778_a("AspectFilter", te.aspectFilter.getTag());
            }
            return drop;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public SoundType func_185467_w() {
        return SoundsTC.JAR;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.75, 0.8125);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        spillEssentia = false;
        super.func_180663_b(worldIn, pos, state);
        spillEssentia = true;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileAbstractJarFillable) {
            this.spawnFilledJar(worldIn, pos, state, (TileAbstractJarFillable)te);
        } else {
            super.func_180653_a(worldIn, pos, state, chance, fortune);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        if (te instanceof TileAbstractJarFillable) {
            this.spawnFilledJar(worldIn, pos, state, (TileAbstractJarFillable)te);
        } else {
            super.func_180657_a(worldIn, player, pos, state, null, stack);
        }
    }

    private void spawnFilledJar(World world, BlockPos pos, IBlockState state, TileAbstractJarFillable te) {
        ItemStack drop = new ItemStack((Block)this, 1, this.func_176201_c(state));
        if (te.amount > 0) {
            ((BlockAbstractJarItem)drop.func_77973_b()).setAspects(drop, new AspectList().add(te.aspect, te.amount));
        }
        if (te.aspectFilter != null) {
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            drop.func_77978_p().func_74778_a("AspectFilter", te.aspectFilter.getTag());
        }
        if (te.blocked) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(ItemsTC.jarBrace));
        }
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase ent, ItemStack stack) {
        int l = MathHelper.func_76128_c((double)((double)(ent.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAbstractJarFillable) {
            if (l == 0) {
                ((TileAbstractJarFillable)tile).facing = 2;
            }
            if (l == 1) {
                ((TileAbstractJarFillable)tile).facing = 5;
            }
            if (l == 2) {
                ((TileAbstractJarFillable)tile).facing = 3;
            }
            if (l == 3) {
                ((TileAbstractJarFillable)tile).facing = 4;
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileAbstractJarFillable && !player.func_184586_b(hand).func_190926_b()) {
            EssentiaJarManager.IJar jar;
            TileAbstractJarFillable tile = (TileAbstractJarFillable)te;
            ItemStack held = player.func_184586_b(hand);
            if (held.func_77973_b() == ItemsTC.phial) {
                ItemPhial ip = (ItemPhial)ItemsTC.phial;
                if (held.func_77952_i() == 0 && tile.amount >= 10) {
                    if (world.field_72995_K) {
                        return true;
                    }
                    Aspect asp = tile.aspect;
                    if (asp != null && tile.takeFromContainer(asp, 10)) {
                        held.func_190918_g(1);
                        ItemStack phial = new ItemStack((Item)ip, 1, 1);
                        ip.setAspects(phial, new AspectList().add(asp, 10));
                        if (!player.field_71071_by.func_70441_a(phial)) {
                            world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), phial));
                        }
                        SoundUtil.playSoundEffect((World)world, (String)SoundEvents.field_187615_H.getRegistryName().toString(), (BlockPos)pos, (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                        player.field_71069_bz.func_75142_b();
                        return true;
                    }
                } else {
                    AspectList al = ip.getAspects(player.func_184586_b(hand));
                    if (al != null && al.size() == 1) {
                        Aspect aspect = al.getAspects()[0];
                        if (player.func_184586_b(hand).func_77952_i() != 0 && tile.amount <= tile.getCapacity() - 10 && tile.doesContainerAccept(aspect)) {
                            if (world.field_72995_K) {
                                return true;
                            }
                            if (tile.addToContainer(aspect, 10) == 0) {
                                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 3);
                                tile.syncTile(true);
                                player.func_184586_b(hand).func_190918_g(1);
                                if (!player.field_71071_by.func_70441_a(new ItemStack((Item)ip, 1, 0))) {
                                    world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack((Item)ip, 1, 0)));
                                }
                                SoundUtil.playSoundEffect((World)world, (String)SoundEvents.field_191241_J.getRegistryName().toString(), (BlockPos)pos, (float)0.5f, (float)1.0f, (SoundCategory)SoundCategory.PLAYERS);
                                player.field_71069_bz.func_75142_b();
                                return true;
                            }
                        }
                    }
                }
            } else if (held.func_190916_E() == 1 && (jar = EssentiaJarManager.fromStack(held)) != null && jar.getEssentia(held).size() > 0) {
                boolean didTheThing = false;
                AspectList list = jar.getEssentia(held);
                for (Aspect a : list.getAspectsSortedByAmount()) {
                    if (tile.aspect != null && (tile.aspect != a || tile.amount >= tile.getCapacity())) continue;
                    int e = Math.min(tile.getCapacity() - tile.amount, list.getAmount(a));
                    tile.aspect = a;
                    tile.addToContainer(a, e);
                    jar.drain(held, a, e);
                    didTheThing = true;
                }
                if (didTheThing) {
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.jar, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
                    world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.5f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f, false);
                }
            }
        } else if (te != null && te instanceof TileAbstractJarFillable && !((TileAbstractJarFillable)te).blocked && player.func_184586_b(hand).func_77973_b() == ItemsTC.jarBrace) {
            ((TileAbstractJarFillable)te).blocked = true;
            player.func_184586_b(hand).func_190918_g(1);
            if (world.field_72995_K) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.key, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            } else {
                te.func_70296_d();
            }
        } else if (te != null && te instanceof TileAbstractJarFillable && player.func_70093_af() && ((TileAbstractJarFillable)te).aspectFilter != null && side.ordinal() == ((TileAbstractJarFillable)te).facing) {
            ((TileAbstractJarFillable)te).aspectFilter = null;
            if (world.field_72995_K) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.page, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            } else {
                world.func_72838_d((Entity)new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f + (float)side.func_82601_c() / 3.0f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f + (float)side.func_82599_e() / 3.0f), new ItemStack(ItemsTC.label)));
            }
        } else if (te != null && te instanceof TileAbstractJarFillable && player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
            if (((TileAbstractJarFillable)te).aspectFilter == null) {
                ((TileAbstractJarFillable)te).aspect = null;
            }
            if (world.field_72995_K) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.jar, SoundCategory.BLOCKS, 0.4f, 1.0f, false);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 0.5f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.3f, false);
            } else {
                AuraHelper.polluteAura((World)world, (BlockPos)pos, (float)((TileAbstractJarFillable)te).amount, (boolean)true);
            }
            ((TileAbstractJarFillable)te).amount = 0;
            te.func_70296_d();
        }
        return true;
    }

    public boolean applyLabel(EntityPlayer player, BlockPos pos, EnumFacing side, ItemStack labelstack) {
        TileEntity te = player.field_70170_p.func_175625_s(pos);
        if (te != null && te instanceof TileAbstractJarFillable && ((TileAbstractJarFillable)te).aspectFilter == null) {
            if (((TileAbstractJarFillable)te).amount == 0 && ((IEssentiaContainerItem)labelstack.func_77973_b()).getAspects(labelstack) == null) {
                return false;
            }
            if (((TileAbstractJarFillable)te).amount == 0 && ((IEssentiaContainerItem)labelstack.func_77973_b()).getAspects(labelstack) != null) {
                ((TileAbstractJarFillable)te).aspect = ((IEssentiaContainerItem)labelstack.func_77973_b()).getAspects(labelstack).getAspects()[0];
            }
            this.func_180633_a(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), (EntityLivingBase)player, null);
            ((TileAbstractJarFillable)te).aspectFilter = ((TileAbstractJarFillable)te).aspect;
            player.field_70170_p.markAndNotifyBlock(pos, player.field_70170_p.func_175726_f(pos), player.field_70170_p.func_180495_p(pos), player.field_70170_p.func_180495_p(pos), 3);
            te.func_70296_d();
            player.field_70170_p.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundsTC.jar, SoundCategory.BLOCKS, 0.4f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileAbstractJarFillable) {
            float r = (float)((TileAbstractJarFillable)tile).amount / 250.0f;
            return MathHelper.func_76141_d((float)(r * 14.0f)) + (((TileAbstractJarFillable)tile).amount > 0 ? 1 : 0);
        }
        return super.func_180641_l(state, world, pos);
    }

    public ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    public static class BlockAbstractJarItem
    extends ItemBlock
    implements IEssentiaContainerItem {
        public final BlockAbstractEssentiaJar field_150939_a;

        protected BlockAbstractJarItem(BlockAbstractEssentiaJar bl) {
            super((Block)bl);
            this.field_150939_a = bl;
        }

        public boolean showDurabilityBar(ItemStack stack) {
            return this.getAspects(stack) != null;
        }

        public double getDurabilityForDisplay(ItemStack stack) {
            AspectList al = this.getAspects(stack);
            return al == null ? 0.0 : 1.0 - (double)al.visSize() / (double)this.field_150939_a.capacity;
        }

        public int getRGBDurabilityForDisplay(ItemStack stack) {
            AspectList al = this.getAspects(stack);
            if (al != null) {
                float percent = (float)this.getDurabilityForDisplay(stack);
                int rgb = AspectUtil.getColor(al, true);
                float r = ColorHelper.getRed((int)rgb);
                float g = ColorHelper.getGreen((int)rgb);
                float b = ColorHelper.getBlue((int)rgb);
                return ColorHelper.packRGB((float)r, (float)g, (float)b);
            }
            return super.getRGBDurabilityForDisplay(stack);
        }

        public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
            Block bi = world.func_180495_p(pos).func_177230_c();
            ItemStack itemstack = player.func_184586_b(hand);
            if (bi == BlocksTC.alembic && !world.field_72995_K) {
                TileAlembic tile = (TileAlembic)world.func_175625_s(pos);
                if (tile.amount > 0) {
                    if (this.getFilter(itemstack) != null && this.getFilter(itemstack) != tile.aspect) {
                        return EnumActionResult.FAIL;
                    }
                    if (this.getAspects(itemstack) != null && this.getAspects(itemstack).getAspects()[0] != tile.aspect) {
                        return EnumActionResult.FAIL;
                    }
                    int amt = tile.amount;
                    if (this.getAspects(itemstack) != null && this.getAspects(itemstack).visSize() + amt > 250) {
                        amt = Math.abs(this.getAspects(itemstack).visSize() - 250);
                    }
                    if (amt <= 0) {
                        return EnumActionResult.FAIL;
                    }
                    Aspect a = tile.aspect;
                    if (tile.takeFromContainer(tile.aspect, amt)) {
                        int base = this.getAspects(itemstack) == null ? 0 : this.getAspects(itemstack).visSize();
                        int n = base;
                        if (itemstack.func_190916_E() > 1) {
                            ItemStack stack = itemstack.func_77946_l();
                            this.setAspects(stack, new AspectList().add(a, base + amt));
                            itemstack.func_190918_g(1);
                            stack.func_190920_e(1);
                            if (!player.field_71071_by.func_70441_a(stack)) {
                                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack));
                            }
                        } else {
                            this.setAspects(itemstack, new AspectList().add(a, base + amt));
                        }
                        player.func_184185_a(SoundEvents.field_187615_H, 0.25f, 1.0f);
                        player.field_71069_bz.func_75142_b();
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.PASS;
        }

        public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
            TileEntity te;
            boolean b = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
            if (b && !world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileAbstractJarFillable) {
                TileAbstractJarFillable jar = (TileAbstractJarFillable)te;
                jar.setAspects(this.getAspects(stack));
                if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("AspectFilter")) {
                    jar.aspectFilter = Aspect.getAspect((String)stack.func_77978_p().func_74779_i("AspectFilter"));
                }
                te.func_70296_d();
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), newState, newState, 3);
            }
            return b;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("AspectFilter")) {
                String tf = stack.func_77978_p().func_74779_i("AspectFilter");
                Aspect tag = Aspect.getAspect((String)tf);
                tooltip.add("\u00a75" + tag.getName());
            }
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
        }

        public AspectList getAspects(ItemStack itemstack) {
            if (itemstack.func_77942_o()) {
                AspectList aspects = new AspectList();
                aspects.readFromNBT(itemstack.func_77978_p());
                return aspects.size() > 0 ? aspects : null;
            }
            return null;
        }

        public Aspect getFilter(ItemStack itemstack) {
            if (itemstack.func_77942_o()) {
                return Aspect.getAspect((String)itemstack.func_77978_p().func_74779_i("AspectFilter"));
            }
            return null;
        }

        public void setAspects(ItemStack itemstack, AspectList aspects) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            aspects.writeToNBT(itemstack.func_77978_p());
        }

        public boolean ignoreContainedAspects() {
            return false;
        }
    }
}

