/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.asm;

import com.zeitheron.hammercore.asm.HCASM;
import com.zeitheron.hammercore.lib.zlib.utils.TaskedThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

class TransformerSystem {
    private final List<IASMHook> hooks = new ArrayList<IASMHook>();
    private final TaskedThread SAVE_THREAD = new TaskedThread();
    private final File CLASS_SAVE_DIR = new File("HammerCore", "asm_classes");
    String currentClass;
    String transformedCurrentClass;
    private String indentstr = "";
    private int indents = 0;

    TransformerSystem() {
    }

    private void saveClass(byte[] original, byte[] modified, String clazz) {
        byte[] o = (byte[])original.clone();
        byte[] m = (byte[])modified.clone();
        this.SAVE_THREAD.addTask(() -> {
            if (!this.CLASS_SAVE_DIR.isDirectory()) {
                this.CLASS_SAVE_DIR.mkdirs();
            }
            try {
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(this.CLASS_SAVE_DIR, clazz.replaceAll("/", "_").replaceAll("[.]", "_") + ".zip")));
                zos.putNextEntry(new ZipEntry("origin.class"));
                zos.write(original);
                zos.closeEntry();
                if (!Arrays.equals(modified, original)) {
                    zos.putNextEntry(new ZipEntry("modified.class"));
                    zos.write(modified);
                    zos.closeEntry();
                }
                zos.putNextEntry(new ZipEntry("methods.txt"));
                ClassNode cn = ObjectWebUtils.loadClass(m);
                for (MethodNode mn : cn.methods) {
                    zos.write((mn.name + " " + mn.desc + "\n").getBytes());
                }
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                this.info("Failed to save ASM class for " + clazz);
                e.printStackTrace();
            }
        });
    }

    public void push() {
        if (this.indents < 15) {
            ++this.indents;
        }
        this.indentstr = "";
        for (int i = 0; i < this.indents; ++i) {
            this.indentstr = this.indentstr + "  ";
        }
    }

    public void pop() {
        if (this.indents > 0) {
            --this.indents;
        }
        this.indentstr = "";
        for (int i = 0; i < this.indents; ++i) {
            this.indentstr = this.indentstr + "  ";
        }
    }

    public void info(String text) {
        if (this.indents == 0) {
            HCASM.ASM_LOG.info(text);
        } else {
            HCASM.ASM_LOG.info(this.indentstr + "-" + text);
        }
    }

    public void addHook(IASMHook hook) {
        this.hooks.add(hook);
    }

    public String getCurrentClass() {
        return this.currentClass;
    }

    public String getTransformedCurrentClass() {
        return this.transformedCurrentClass;
    }

    public byte[] transform(String name, String transformedName, byte[] data) {
        this.currentClass = name;
        this.transformedCurrentClass = transformedName;
        byte[] origin = data;
        boolean l = false;
        for (IASMHook h : this.hooks) {
            if (!h.accepts(transformedName) && !h.accepts(name)) continue;
            if (!l) {
                l = true;
                this.info("Transforming " + transformedName + " (" + name + ")...");
            }
            this.push();
            if (h.opName() != null) {
                this.info(h.opName());
            }
            boolean obf = !name.equals(transformedName);
            ClassNode node = ObjectWebUtils.loadClass(data);
            this.currentClass = name;
            this.transformedCurrentClass = transformedName;
            this.push();
            h.transform(node, obf);
            this.pop();
            data = ObjectWebUtils.writeClassToByteArray(node);
            this.pop();
        }
        this.currentClass = null;
        this.transformedCurrentClass = null;
        return data;
    }

    static class ObjectWebUtils {
        ObjectWebUtils() {
        }

        public static ClassNode loadClass(byte[] data) {
            ClassReader reader = new ClassReader(data);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            return node;
        }

        public static ClassNode loadClass(InputStream stream) throws IOException {
            ClassReader reader = new ClassReader(stream);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            return node;
        }

        public static ClassNode loadClass(File file) throws IOException {
            FileInputStream stream = new FileInputStream(file);
            ClassNode node = ObjectWebUtils.loadClass(stream);
            stream.close();
            return node;
        }

        public static ClassNode loadClass(URL url) throws IOException {
            URLConnection conn = url.openConnection();
            try {
                conn.setDoInput(true);
                conn.connect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            InputStream stream = conn.getInputStream();
            ClassNode node = ObjectWebUtils.loadClass(stream);
            stream.close();
            return node;
        }

        public static byte[] writeClassToByteArray(ClassNode node) {
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }

        public static void writeClassToOutputStream(ClassNode node, OutputStream stream) throws IOException {
            stream.write(ObjectWebUtils.writeClassToByteArray(node));
        }

        public static void writeClassToFile(ClassNode node, File file) throws IOException {
            FileOutputStream os = new FileOutputStream(file);
            ObjectWebUtils.writeClassToOutputStream(node, os);
            os.close();
        }

        public static void writeClassToURL(ClassNode node, URL url) throws IOException {
            URLConnection conn = url.openConnection();
            try {
                conn.setDoOutput(true);
                conn.connect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            OutputStream os = conn.getOutputStream();
            ObjectWebUtils.writeClassToOutputStream(node, os);
            os.close();
        }
    }

    static interface IASMHook {
        public boolean accepts(String var1);

        public String opName();

        public void transform(ClassNode var1, boolean var2);
    }
}

