/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.thaumicadditions.api.blueprint;

import java.util.Objects;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.crafting.Part;

public class BlueprintBuilder {
    public final Part[][][] parts;
    public int cx;
    public int cy;
    public int cz;

    public BlueprintBuilder(int xSize, int ySize, int zSize) {
        this.parts = new Part[ySize][][];
        for (int i = 0; i < ySize; ++i) {
            this.parts[i] = new Part[xSize][];
            for (int j = 0; j < xSize; ++j) {
                this.parts[i][j] = new Part[zSize];
            }
        }
    }

    public static void stackTogether(NonNullList<ItemStack> stacks) {
        block0: for (int i = 0; i < stacks.size(); ++i) {
            ItemStack given = (ItemStack)stacks.get(i);
            if (given.func_190926_b()) {
                stacks.remove(0);
                i = 0;
                continue;
            }
            for (int j = 0; j < i; ++j) {
                ItemStack loc = (ItemStack)stacks.get(j);
                if (!loc.func_77969_a(given) || !Objects.equals(loc.func_77978_p(), given.func_77978_p())) continue;
                given.func_190917_f(loc.func_190916_E());
                stacks.remove(j);
                i = 0;
                continue block0;
            }
        }
    }

    public BlueprintBuilder center(int x, int y, int z) {
        this.cx = x;
        this.cy = y;
        this.cz = z;
        return this;
    }

    public BlueprintBuilder part(int x, int y, int z, Object in, Object out) {
        this.parts[this.parts.length - (y + this.cy) - 1][x + this.cx][z + this.cz] = new Part(in, out);
        return this;
    }

    public ThaumcraftApi.BluePrint build(String research, ItemStack display) {
        NonNullList ings = NonNullList.func_191196_a();
        Part[][][] partArray = this.parts;
        int n = partArray.length;
        for (int i = 0; i < n; ++i) {
            Part[][] p1;
            Part[][] partArray2 = p1 = partArray[i];
            int n2 = partArray2.length;
            for (int j = 0; j < n2; ++j) {
                Part[] p2;
                for (Part p : p2 = partArray2[j]) {
                    if (p == null) continue;
                    Object o = p.getSource();
                    if (o instanceof ItemStack) {
                        ings.add((Object)((ItemStack)o));
                        continue;
                    }
                    if (o instanceof Block) {
                        if (o instanceof BlockFluidBase) {
                            ings.add((Object)FluidUtil.getFilledBucket((FluidStack)new FluidStack(((BlockFluidBase)o).getFluid(), 1000)));
                            continue;
                        }
                        ings.add((Object)new ItemStack((Block)o));
                        continue;
                    }
                    if (!(o instanceof IBlockState)) continue;
                    ((IBlockState)o).func_177230_c().func_180660_a((IBlockState)o, new Random(), 0);
                }
            }
        }
        BlueprintBuilder.stackTogether((NonNullList<ItemStack>)ings);
        return new ThaumcraftApi.BluePrint(research, display, this.parts, (ItemStack[])ings.toArray((Object[])new ItemStack[ings.size()]));
    }
}

