/*
 * Decompiled with CFR 0.152.
 */
package techreborn.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import techreborn.Core;
import techreborn.blocks.BlockRubberLeaves;
import techreborn.blocks.BlockRubberLog;
import techreborn.init.ModBlocks;

public class RubberTreeGenerator
extends WorldGenerator {
    boolean isWorldGen = true;

    public RubberTreeGenerator() {
    }

    public RubberTreeGenerator(boolean isWorldGen) {
        super(!isWorldGen);
        this.isWorldGen = isWorldGen;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int retries = rand.nextInt(3) + 2;
        for (int c = 0; c < retries; ++c) {
            int y;
            int x = position.func_177958_n() + 8 + rand.nextInt(16);
            int z = position.func_177952_p() + 8 + rand.nextInt(16);
            for (y = worldIn.func_189649_b(x, z) - 1; worldIn.func_175623_d(new BlockPos(x, y, z)) && y > 0; --y) {
            }
            if (this.growTree(worldIn, rand, x, y + 1, z)) continue;
            --retries;
        }
        return false;
    }

    public boolean growTree(World world, Random rand, int x, int y, int z) {
        int treeHeight = rand.nextInt(5) + Core.worldGen.config.rubberTreeConfig.treeBaseHeight;
        int worldHeight = world.func_72800_K();
        if (y >= 1 && y + treeHeight + 1 <= worldHeight) {
            IBlockState baseSate = world.func_180495_p(new BlockPos(x, y - 1, z));
            Block baseBlock = baseSate.func_177230_c();
            boolean hasPlacedBlock = false;
            if (baseBlock != null && baseBlock.canSustainPlant(baseSate, (IBlockAccess)world, new BlockPos(x, y - 1, z), EnumFacing.UP, (IPlantable)ModBlocks.RUBBER_SAPLING) && y < worldHeight - treeHeight - 1) {
                int zOffset;
                int xOffset;
                int yOffset;
                for (yOffset = y; yOffset <= y + 1 + treeHeight; ++yOffset) {
                    int radius = 1;
                    if (yOffset == y) {
                        radius = 0;
                    }
                    if (yOffset >= y + 1 + treeHeight - 2) {
                        radius = 2;
                    }
                    if (yOffset >= 0 & yOffset < worldHeight) {
                        for (xOffset = x - radius; xOffset <= x + radius; ++xOffset) {
                            for (zOffset = z - radius; zOffset <= z + radius; ++zOffset) {
                                IBlockState state = world.func_180495_p(new BlockPos(xOffset, yOffset, zOffset));
                                Block block = state.func_177230_c();
                                if (block == null || block.isLeaves(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) || block.isAir(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) || block.canBeReplacedByLeaves(state, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset))) continue;
                                return false;
                            }
                        }
                        continue;
                    }
                    return false;
                }
                BlockPos treeBase = new BlockPos(x, y, z);
                BlockPos treeRoot = treeBase.func_177977_b();
                IBlockState state = world.func_180495_p(treeRoot);
                state.func_177230_c().onPlantGrow(state, world, treeRoot, treeBase);
                for (yOffset = y - 3 + treeHeight; yOffset <= y + treeHeight; ++yOffset) {
                    int var12 = yOffset - (y + treeHeight);
                    int center = 1 - var12 / 2;
                    for (xOffset = x - center; xOffset <= x + center; ++xOffset) {
                        int xPos = xOffset - x;
                        int t = xPos >> 15;
                        xPos = xPos + t ^ t;
                        for (zOffset = z - center; zOffset <= z + center; ++zOffset) {
                            int zPos = zOffset - z;
                            t = zPos >> 31;
                            zPos = zPos + t ^ t;
                            IBlockState state1 = world.func_180495_p(new BlockPos(xOffset, yOffset, zOffset));
                            Block block = state1.func_177230_c();
                            if (!(xPos != center | zPos != center) && (rand.nextInt(2) == 0 || var12 == 0) || block != null && !block.isLeaves(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) && !block.isAir(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset)) && !block.canBeReplacedByLeaves(state1, (IBlockAccess)world, new BlockPos(xOffset, yOffset, zOffset))) continue;
                            this.func_175903_a(world, new BlockPos(xOffset, yOffset, zOffset), ModBlocks.RUBBER_LEAVES.func_176223_P().func_177226_a((IProperty)BlockRubberLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRubberLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                            hasPlacedBlock = true;
                        }
                    }
                }
                BlockPos topLogPos = null;
                for (yOffset = 0; yOffset < treeHeight; ++yOffset) {
                    BlockPos blockpos = new BlockPos(x, y + yOffset, z);
                    IBlockState state1 = world.func_180495_p(blockpos);
                    Block block = state1.func_177230_c();
                    if (block != null && !block.isAir(state1, (IBlockAccess)world, blockpos) && !block.isLeaves(state1, (IBlockAccess)world, blockpos) && !block.func_176200_f((IBlockAccess)world, blockpos)) continue;
                    IBlockState newState = ModBlocks.RUBBER_LOG.func_176223_P();
                    boolean isAddingSap = false;
                    if (rand.nextInt(Core.worldGen.config.rubberTreeConfig.sapRarity) == 0) {
                        newState = newState.func_177226_a((IProperty)BlockRubberLog.HAS_SAP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRubberLog.SAP_SIDE, (Comparable)EnumFacing.func_176731_b((int)rand.nextInt(4)));
                        isAddingSap = true;
                    }
                    if (isAddingSap) {
                        world.func_180501_a(blockpos, newState, 2);
                    } else {
                        this.func_175903_a(world, blockpos, newState);
                    }
                    hasPlacedBlock = true;
                    topLogPos = blockpos;
                }
                if (topLogPos != null) {
                    for (int i = 0; i < Core.worldGen.config.rubberTreeConfig.spireHeight; ++i) {
                        BlockPos spikePos = topLogPos.func_177981_b(i);
                        this.func_175903_a(world, spikePos, ModBlocks.RUBBER_LEAVES.func_176223_P().func_177226_a((IProperty)BlockRubberLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)BlockRubberLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
            return hasPlacedBlock;
        }
        return false;
    }
}

