/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ingredients.ItemDusts;

@RebornRegistry(modID="techreborn")
public class IndustrialSawmillRecipes
extends RecipeMethods {
    static FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);
    @ConfigRegistry(config="recipes", category="sawmill", key="plankCount", comment="Number of planks the saw mill will ouput")
    public static int plankCount = 4;
    @ConfigRegistry(config="recipes", category="sawmill", key="disableRecipes", comment="Set to true to disable sawmill recipes from loading.")
    public static boolean disableRecipes = false;

    public static void init() {
        if (disableRecipes) {
            return;
        }
        InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, 1, 1);
        inventoryCrafting.func_70299_a(0, ItemStack.field_190927_a);
        List logs = OreDictionary.getOres((String)"logWood").stream().filter(Objects::nonNull).map(ItemStack::func_77946_l).collect(Collectors.toList());
        for (ItemStack logStack : logs) {
            if (logStack.func_77952_i() == Short.MAX_VALUE && logStack.func_77981_g()) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack newStack = logStack.func_77946_l();
                    newStack.func_77964_b(i);
                    inventoryCrafting.func_70299_a(0, newStack);
                    ItemStack output = IndustrialSawmillRecipes.findMatchingRecipe(inventoryCrafting);
                    if (output.func_190926_b() || !ItemUtils.isInputEqual((Object)"plankWood", (ItemStack)output, (boolean)false, (boolean)false, (boolean)false)) continue;
                    IndustrialSawmillRecipes.addRecipe(newStack.func_77946_l(), output.func_77946_l());
                }
                continue;
            }
            logStack.func_77964_b(0);
            inventoryCrafting.func_70299_a(0, logStack.func_77946_l());
            ItemStack output = IndustrialSawmillRecipes.findMatchingRecipe(inventoryCrafting);
            if (output.func_190926_b() || !ItemUtils.isInputEqual((Object)"plankWood", (ItemStack)output, (boolean)false, (boolean)false, (boolean)false)) continue;
            IndustrialSawmillRecipes.addRecipe(logStack.func_77946_l(), output.func_77946_l());
        }
    }

    @Nonnull
    public static ItemStack findMatchingRecipe(InventoryCrafting inv) {
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!recipe.func_194133_a(1, 1) || !recipe.func_77569_a(inv, null)) continue;
            return recipe.func_77572_b(inv);
        }
        return ItemStack.field_190927_a;
    }

    public static void addRecipe(ItemStack log, ItemStack plank) {
        plank.func_190920_e(plankCount);
        IndustrialSawmillRecipes.register(log, WATER, 100, 128, plank, ItemDusts.getDustByName("sawDust", 3), IndustrialSawmillRecipes.getStack(Items.field_151121_aF, 1));
    }

    static void register(ItemStack input1, FluidStack fluid, int ticks, int euPerTick, ItemStack ... outputs) {
        if (outputs.length == 3) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], outputs[1], outputs[2], ticks, euPerTick, false));
        } else if (outputs.length == 2) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], outputs[1], null, ticks, euPerTick, false));
        } else if (outputs.length == 1) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], null, null, ticks, euPerTick, false));
        } else {
            throw new InvalidParameterException("Invalid industrial sawmill outputs: " + outputs);
        }
    }
}

