/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import electroblob.tfspellpack.entity.living.EntityTwilightWraithMinion;
import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityBlazeMinion;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.entity.EntityTFHedgeSpider;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFSkeletonDruid;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFWraith;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFPenguin;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFTinyBird;

public class Transformation
extends SpellRay {
    public static final BiMap<Class<? extends EntityLivingBase>, Class<? extends EntityLivingBase>> TRANSFORMATIONS = HashBiMap.create();

    @SafeVarargs
    public static void addTransformation(Class<? extends EntityLivingBase> ... entities) {
        Class<? extends EntityLivingBase> previousEntity = entities[entities.length - 1];
        for (Class<? extends EntityLivingBase> entity : entities) {
            TRANSFORMATIONS.put(previousEntity, entity);
            previousEntity = entity;
        }
    }

    public Transformation() {
        super("tfspellpack", "transformation", SpellActions.POINT, false);
        this.soundValues(0.5f, 1.0f, 0.0f);
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            Class newEntityClass;
            double xPos = target.field_70165_t;
            double yPos = target.field_70163_u;
            double zPos = target.field_70161_v;
            Class clazz = newEntityClass = caster != null && caster.func_70093_af() ? (Class)TRANSFORMATIONS.inverse().get(target.getClass()) : (Class)TRANSFORMATIONS.get(target.getClass());
            if (newEntityClass == null) {
                return false;
            }
            EntityLivingBase newEntity = null;
            try {
                newEntity = (EntityLivingBase)newEntityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception e) {
                Wizardry.logger.error("Error while attempting to transform entity " + target.getClass() + " to entity " + newEntityClass);
                e.printStackTrace();
            }
            if (newEntity == null) {
                return false;
            }
            if (!world.field_72995_K) {
                newEntity.func_70606_j(((EntityLivingBase)target).func_110143_aJ());
                NBTTagCompound tag = new NBTTagCompound();
                target.func_189511_e(tag);
                NBTExtras.removeUniqueId((NBTTagCompound)tag, (String)"UUID");
                newEntity.func_70020_e(tag);
                target.func_70106_y();
                newEntity.func_70107_b(xPos, yPos, zPos);
                world.func_72838_d((Entity)newEntity);
            } else {
                for (int i = 0; i < 20; ++i) {
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC, (Random)world.field_73012_v, (double)xPos, (double)(yPos + 1.0), (double)zPos, (double)1.0, (boolean)false).clr(26741).spawn(world);
                }
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).pos(xPos, yPos, zPos).clr(4980634).spawn(world);
            }
            this.playSound(world, (EntityLivingBase)target, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    static {
        Transformation.addTransformation(EntityTFMinotaur.class, EntityPigZombie.class);
        Transformation.addTransformation(EntityTFDeer.class, EntityCow.class);
        Transformation.addTransformation(EntityTFBighorn.class, EntitySheep.class);
        Transformation.addTransformation(EntityTFBoar.class, EntityPig.class);
        Transformation.addTransformation(EntityTFBunny.class, EntityRabbit.class);
        Transformation.addTransformation(EntityTFTinyBird.class, EntityParrot.class);
        Transformation.addTransformation(EntityTFRaven.class, EntityBat.class);
        Transformation.addTransformation(EntityTFHostileWolf.class, EntityWolf.class);
        Transformation.addTransformation(EntityTFPenguin.class, EntityChicken.class);
        Transformation.addTransformation(EntityTFHedgeSpider.class, EntitySpider.class);
        Transformation.addTransformation(EntityTFSwarmSpider.class, EntityCaveSpider.class);
        Transformation.addTransformation(EntityTFWraith.class, EntityBlaze.class);
        Transformation.addTransformation(EntityTFRedcap.class, EntityVillager.class);
        Transformation.addTransformation(EntityTFHedgeSpider.class, EntitySpider.class);
        Transformation.addTransformation(EntityTFSkeletonDruid.class, EntityWitch.class);
        Transformation.addTransformation(EntityTwilightWraithMinion.class, EntityBlazeMinion.class);
    }
}

