/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.entity.living.EntityMiniGhastMinion;
import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GhastTrap
extends SpellRay {
    public static final String MINION_LIFETIME = "minion_lifetime";
    public static final String MINION_COUNT = "minion_count";
    public static final String SUMMON_RADIUS = "summon_radius";

    public GhastTrap() {
        super("tfspellpack", "ghast_trap", SpellActions.SUMMON, false);
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{MINION_LIFETIME, MINION_COUNT, SUMMON_RADIUS});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (world.func_175710_j(pos.func_177984_a())) {
            if (!world.field_72995_K) {
                for (int i = 0; i < this.getProperty(MINION_COUNT).intValue(); ++i) {
                    int range = this.getProperty(SUMMON_RADIUS).intValue();
                    BlockPos pos1 = BlockUtils.findNearbyFloorSpace((World)world, (BlockPos)pos, (int)range, (int)(range * 2));
                    pos1 = pos1 != null ? pos1.func_177981_b(1) : pos.func_177964_d(world.field_73012_v.nextInt(range * 2) - range).func_177965_g(world.field_73012_v.nextInt(range * 2) - range);
                    EntityMiniGhastMinion minion = new EntityMiniGhastMinion(world);
                    minion.func_70107_b((double)pos1.func_177958_n() + 0.5, pos1.func_177956_o(), (double)pos1.func_177952_p() + 0.5);
                    minion.setCaster(caster);
                    minion.setLifetime((int)(this.getProperty(MINION_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                    minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", (double)(modifiers.get("minion_health") - 1.0f), 2));
                    minion.func_70606_j(minion.func_110138_aP());
                    world.func_72838_d((Entity)minion);
                }
                boolean doFireTick = world.func_82736_K().func_82766_b("doFireTick");
                if (doFireTick && !BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)pos)) {
                    world.func_82736_K().func_82764_b("doFireTick", "false");
                }
                EntityLightningBolt entitylightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), false);
                world.func_72942_c((Entity)entitylightning);
                if (doFireTick && !BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)pos)) {
                    world.func_82736_K().func_82764_b("doFireTick", "true");
                }
            }
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

