/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.entity.construct.EntityFireJet;
import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellConstruct;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FireJets
extends SpellConstruct<EntityFireJet> {
    public static final String FIRE_JETS = "fire_jets";

    public FireJets() {
        super("tfspellpack", FIRE_JETS, SpellActions.POINT_UP, EntityFireJet::new, false);
        this.soundValues(3.0f, 1.0f, 0.2f);
        this.addProperties(new String[]{"effect_radius", FIRE_JETS, "damage", "burn_duration"});
        this.overlap(true);
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected boolean spawnConstruct(World world, double x, double y, double z, @Nullable EnumFacing side, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        boolean success = false;
        double radius = this.getProperty("effect_radius").doubleValue() * (double)modifiers.get(WizardryItems.blast_upgrade);
        int jetCount = this.getProperty(FIRE_JETS).intValue();
        for (int i = 0; i < jetCount; ++i) {
            double pz;
            float angle = (float)Math.PI * 2 * ((float)i + world.field_73012_v.nextFloat() * 0.5f) / (float)jetCount;
            double px = x + radius * (double)MathHelper.func_76134_b((float)angle) + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            Integer py = BlockUtils.getNearestFloor((World)world, (BlockPos)new BlockPos(px, y, pz = z + radius * (double)MathHelper.func_76126_a((float)angle) + world.field_73012_v.nextDouble() * 2.0 - 1.0), (int)((int)radius));
            if (py == null || !super.spawnConstruct(world, px, (double)py.intValue(), pz, side, caster, modifiers)) continue;
            success = true;
            BlockPos pos = new BlockPos(px, (double)py.intValue(), pz);
            if (world.field_72995_K || !BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)pos)) continue;
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
        }
        return success;
    }
}

