/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.spell;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.util.TFSPUtils;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import twilightforest.TwilightForestMod;
import twilightforest.client.particle.TFParticleType;

public class CarminiteSingularity
extends Spell {
    private static final float DAMAGE_RADIUS_FRACTION = 0.8f;
    private static final float EPICENTRE_RADIUS_FRACTION = 0.5f;
    private static final double SUCTION_STRENGTH = 0.05;

    public CarminiteSingularity() {
        super("tfspellpack", "carminite_singularity", SpellActions.POINT_UP, true);
        this.addProperties(new String[]{"effect_radius", "damage"});
        this.npcSelector(TFSPUtils.IN_TF_DIMENSION);
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == TFSPItems.twilight_spell_book || item == TFSPItems.twilight_scroll;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        this.performEffect(world, new Vec3d(x, y, z), null, modifiers);
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    private void performEffect(World world, Vec3d centre, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        List targets = EntityUtils.getLivingWithinRadius((double)radius, (double)centre.field_72450_a, (double)centre.field_72448_b, (double)centre.field_72449_c, (World)world);
        for (Object target : targets) {
            if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)target)) continue;
            double distance = centre.func_72438_d(target.func_174791_d());
            if (distance > radius * 0.5) {
                Vec3d vel = centre.func_178788_d(target.func_174791_d()).func_72432_b().func_186678_a(0.05);
                target.func_70024_g(vel.field_72450_a, vel.field_72448_b, vel.field_72449_c);
                if (target instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)target));
                }
            }
            if (!(distance < radius * (double)0.8f) || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (Entity)target) || ((EntityLivingBase)target).field_70173_aa % ((EntityLivingBase)target).field_70771_an != 1) continue;
            EntityUtils.attackEntityWithoutKnockback((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK), (float)(this.getProperty("damage").floatValue() * modifiers.get("potency")));
            if (!world.field_72995_K) continue;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).clr(16728964).pos(caster != null ? centre.func_178788_d(caster.func_174791_d()) : centre).target((Entity)target).spawn(world);
        }
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)TFSPItems.amulet_carminite)) {
            List projectiles = EntityUtils.getEntitiesWithinRadius((double)radius, (double)centre.field_72450_a, (double)centre.field_72448_b, (double)centre.field_72449_c, (World)world, Entity.class);
            for (Entity projectile : projectiles) {
                if (!(projectile instanceof IProjectile)) continue;
                Vec3d vec = projectile.func_174791_d().func_178788_d(centre).func_72432_b().func_186678_a(0.2);
                projectile.func_70024_g(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            }
        }
        if (world.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double dx = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * radius;
                double dy = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * radius;
                double dz = (world.field_73012_v.nextDouble() * 2.0 - 1.0) * radius;
                TwilightForestMod.proxy.spawnParticle(TFParticleType.GHAST_TRAP, centre.field_72450_a, centre.field_72448_b, centre.field_72449_c, dx, dy, dz);
            }
            if (world.field_73012_v.nextInt(6) == 0) {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).entity((Entity)caster).clr(16767226).scale(2.0f).pos(caster != null ? centre.func_178788_d(caster.func_174791_d()) : centre).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity((Entity)caster).clr(16728964).scale(0.5f).pos(caster != null ? centre.func_178788_d(caster.func_174791_d()) : centre).target(centre.func_72441_c(world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0, world.field_73012_v.nextDouble() * 2.0 - 1.0)).spawn(world);
            }
        }
    }
}

