/*
 * Decompiled with CFR 0.152.
 */
package electroblob.tfspellpack.item;

import electroblob.tfspellpack.registry.TFSPItems;
import electroblob.tfspellpack.registry.TFSPPotions;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import twilightforest.TFConfig;
import twilightforest.entity.EntityTFTomeBolt;

@Mod.EventBusSubscriber
public class TFSPArtefactHandler {
    private static final Potion[] ACCURSED_TOME_EFFECTS = new Potion[]{MobEffects.field_76436_u, MobEffects.field_76440_q, MobEffects.field_76438_s, MobEffects.field_76431_k, MobEffects.field_188424_y, MobEffects.field_76419_f, MobEffects.field_76437_t, MobEffects.field_76421_d};

    private TFSPArtefactHandler() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                float potency = modifiers.get("potency");
                if (artefact != TFSPItems.ring_twilight || player.field_71093_bK != TFConfig.dimension.dimensionID) continue;
                modifiers.set("potency", 1.1f * potency, false);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != TFSPItems.ring_stealth_attack || event.getSource().func_82725_o() || !player.func_70644_a(TFSPPotions.mist_cloak) || !(player.func_70013_c() < 0.5f) || player.func_110144_aD() == event.getEntity() || event.getEntityLiving() instanceof EntityLiving && ((EntityLiving)event.getEntityLiving()).func_70638_az() == player) continue;
                DamageSafetyChecker.attackEntitySafely((Entity)event.getEntity(), (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)player, (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC), (float)(event.getAmount() * 0.5f), (String)event.getSource().field_76373_n, (DamageSource)DamageSource.field_76376_m, (boolean)false);
                event.getEntityLiving().field_70172_ad = 0;
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != TFSPItems.amulet_steeleaf || player.field_71093_bK != TFConfig.dimension.dimensionID || !Arrays.stream(InventoryUtils.ARMOUR_SLOTS).map(s -> player.func_184582_a(s).func_77973_b()).allMatch(i -> i instanceof ItemWizardArmour)) continue;
                event.setAmount(event.getAmount() * 0.9f);
            }
        }
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact != TFSPItems.charm_accursed_tome || !(event.getSource().func_76364_f() instanceof EntityTFTomeBolt)) continue;
                Potion potion = ACCURSED_TOME_EFFECTS[player.func_70681_au().nextInt(ACCURSED_TOME_EFFECTS.length)];
                event.getEntityLiving().func_70690_d(new PotionEffect(potion, 160, 0));
            }
        }
    }
}

