/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell.waystones;

import com.windanesz.spellbundle.Settings;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.WaystoneManager;
import net.blay09.mods.waystones.block.BlockWaystone;
import net.blay09.mods.waystones.block.TileWaystone;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Warp
extends SpellRay {
    protected static final String BOUND_WAYSTONE_TAG = "boundWaystone";
    public static final IStoredVariable<NBTTagCompound> BOUND_WAYSTONE = IStoredVariable.StoredVariable.ofNBT((String)"boundWaystone", (Persistence)Persistence.ALWAYS).setSynced();

    public Warp() {
        super("spellbundle", "warp", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{BOUND_WAYSTONE});
    }

    protected Warp(String modid, String name, EnumAction action, boolean isContinuous) {
        super(modid, name, action, isContinuous);
    }

    public boolean warp(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!caster.func_70093_af()) {
            Optional<WaystoneEntry> waystone = Warp.getBoundWaystone(caster);
            if (waystone.isPresent()) {
                boolean dimensionWarp;
                boolean bl = dimensionWarp = waystone.get().getDimensionId() != caster.func_130014_f_().field_73011_w.getDimension();
                if (dimensionWarp) {
                    if (!world.field_72995_K) {
                        caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".wrong_dimension", new Object[0]), true);
                    }
                    return false;
                }
                caster.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40));
                if (!world.field_72995_K) {
                    Warp.teleportEntity((EntityLivingBase)caster, waystone.get());
                }
                return true;
            }
            if (!world.field_72995_K) {
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".undefined", new Object[0]), true);
            }
        }
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            return this.warp(world, (EntityPlayer)caster, EnumHand.MAIN_HAND, ticksInUse, modifiers);
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_70093_af()) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof TileWaystone) {
                    TileWaystone tileWaystone = ((TileWaystone)tileEntity).getParent();
                    if (!world.field_72995_K) {
                        WaystoneEntry waystone = new WaystoneEntry(tileWaystone);
                        Optional<WaystoneEntry> oldWaystone = Warp.setBoundWaystone((EntityPlayer)caster, waystone);
                        if (oldWaystone.isPresent()) {
                            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:warp.remember_with_old", new Object[]{waystone.getName(), oldWaystone.get().getName()}), true);
                        } else {
                            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:warp.remember", new Object[]{waystone.getName()}), true);
                        }
                        return true;
                    }
                }
            } else {
                return this.warp(world, (EntityPlayer)caster, EnumHand.MAIN_HAND, ticksInUse, modifiers);
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            return this.warp(world, (EntityPlayer)caster, EnumHand.MAIN_HAND, ticksInUse, modifiers);
        }
        return false;
    }

    public static Optional<WaystoneEntry> getBoundWaystone(EntityPlayer player) {
        WizardData data;
        NBTTagCompound compound;
        if (player != null && (compound = (NBTTagCompound)(data = WizardData.get((EntityPlayer)player)).getVariable(BOUND_WAYSTONE)) != null && compound.func_74764_b(BOUND_WAYSTONE_TAG)) {
            WaystoneEntry waystone = WaystoneEntry.read((NBTTagCompound)compound.func_74775_l(BOUND_WAYSTONE_TAG));
            return Optional.of(waystone);
        }
        return Optional.empty();
    }

    protected static Optional<WaystoneEntry> setBoundWaystone(EntityPlayer player, WaystoneEntry waystone) {
        Optional<WaystoneEntry> ret = Optional.empty();
        if (player != null && !player.field_70170_p.field_72995_K) {
            WizardData data = WizardData.get((EntityPlayer)player);
            NBTTagCompound compound = (NBTTagCompound)data.getVariable(BOUND_WAYSTONE);
            if (compound != null && compound.func_74764_b(BOUND_WAYSTONE_TAG)) {
                WaystoneEntry oldWaystone = WaystoneEntry.read((NBTTagCompound)compound.func_74775_l(BOUND_WAYSTONE_TAG));
                ret = Optional.of(oldWaystone);
            }
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74782_a(BOUND_WAYSTONE_TAG, (NBTBase)waystone.writeToNBT());
            data.setVariable(BOUND_WAYSTONE, (Object)tagCompound);
            data.sync();
        }
        return ret;
    }

    protected static boolean teleportEntity(EntityLivingBase entity, WaystoneEntry waystone) {
        if (entity instanceof EntityPlayer) {
            WaystoneManager.teleportToWaystone((EntityPlayer)((EntityPlayer)entity), (WaystoneEntry)waystone);
        } else if (Warp.isEntityAllowed(entity)) {
            EnumFacing facing = (EnumFacing)entity.field_70170_p.func_180495_p(waystone.getPos()).func_177229_b((IProperty)BlockWaystone.FACING);
            BlockPos pos = waystone.getPos().func_177972_a(facing);
            entity.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }
        return false;
    }

    private static boolean isEntityAllowed(EntityLivingBase entityLivingBase) {
        String registryname = EntityList.func_191301_a((Entity)entityLivingBase).toString();
        return !Arrays.stream(Settings.spellTweaksSettings.warp_entity_blacklist).anyMatch(s -> s.equals(registryname));
    }
}

