/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.spell.treasure2;

import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.ITreasureChestProxy;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import com.windanesz.spellbundle.registry.SBItems;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Knock
extends SpellRay {
    private static final String MIN_TIER = "min_tier";

    public Knock() {
        super("spellbundle", "knock", SpellActions.POINT, false);
        this.addProperties(new String[]{MIN_TIER});
    }

    protected Knock(String modid, String name, EnumAction action, boolean isContinuous) {
        super(modid, name, action, isContinuous);
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer && !world.field_72995_K) {
            int minTier = this.getProperty(MIN_TIER).intValue();
            int maxTier = minTier + (int)((modifiers.get("potency") - 1.0f) / 0.15f - 0.2f);
            maxTier = Math.min(3, maxTier);
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)((EntityPlayer)caster), (ItemArtefact.Type[])new ItemArtefact.Type[]{ItemArtefact.Type.RING})) {
                if (artefact != SBItems.ring_key) continue;
                ++maxTier;
            }
            BlockPos chestPos = pos;
            Block block = world.func_180495_p(chestPos).func_177230_c();
            if (block instanceof ITreasureChestProxy) {
                chestPos = ((ITreasureChestProxy)block).getChestPos(chestPos);
                block = world.func_180495_p(chestPos).func_177230_c();
            }
            if (block instanceof AbstractChestBlock) {
                TileEntity tileEntity = world.func_175625_s(chestPos);
                if (tileEntity == null || !(tileEntity instanceof AbstractTreasureChestTileEntity)) {
                    return false;
                }
                AbstractTreasureChestTileEntity chestTileEntity = (AbstractTreasureChestTileEntity)tileEntity;
                if (!chestTileEntity.hasLocks()) {
                    return false;
                }
                List lockStates = chestTileEntity.getLockStates();
                if (lockStates == null || lockStates.isEmpty()) {
                    return false;
                }
                boolean unlocked = false;
                for (LockState lockState : lockStates) {
                    if (lockState.getLock() == null || lockState.getLock().getRarity().ordinal() > maxTier) continue;
                    LockItem lock = lockState.getLock();
                    unlocked = true;
                    lockState.setLock(null);
                    chestTileEntity.sendUpdates();
                    if (TreasureConfig.KEYS_LOCKS.enableLockDrops) {
                        InventoryHelper.func_180173_a((World)world, (double)chestPos.func_177958_n(), (double)chestPos.func_177956_o(), (double)chestPos.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
                    }
                    ((WorldServer)world).func_175739_a(EnumParticleTypes.SPELL_WITCH, (double)((float)chestPos.func_177958_n() + lockState.getSlot().getXOffset()), (double)((float)chestPos.func_177956_o() + lockState.getSlot().getYOffset()), (double)((float)chestPos.func_177952_p() + lockState.getSlot().getZOffset()), 24, 0.0, 0.1, 0.0, 0.1, new int[0]);
                    break;
                }
                if (!unlocked) {
                    ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.spellbundle:knock.weak_spell", new Object[0]), true);
                }
                return true;
            }
        }
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

