/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.registry;

import com.windanesz.spellbundle.integration.Integration;
import com.windanesz.spellbundle.integration.treasure2.Treasure2Integration;
import com.windanesz.spellbundle.integration.treasure2.common.Treasure2Objects;
import com.windanesz.spellbundle.integration.waystones.WaystonesIntegration;
import com.windanesz.spellbundle.item.ItemArtefactSB;
import com.windanesz.spellbundle.item.ItemCharmWishingWell;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryTabs;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="spellbundle")
@Mod.EventBusSubscriber
public final class SBItems {
    public static final Item ring_warpstone = (Item)SBItems.placeholder();
    public static final Item ring_key = (Item)SBItems.placeholder();
    public static final Item charm_frozen_lock = (Item)SBItems.placeholder();
    public static final Item spectral_lock = (Item)SBItems.placeholder();

    private SBItems() {
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        SBItems.registerItem((IForgeRegistry<Item>)registry, "ring_warpstone", new ItemArtefactSB(EnumRarity.EPIC, ItemArtefact.Type.RING, WaystonesIntegration.getInstance()), WaystonesIntegration.getInstance());
        SBItems.registerItem((IForgeRegistry<Item>)registry, "ring_key", new ItemArtefactSB(EnumRarity.RARE, ItemArtefact.Type.RING, Treasure2Integration.getInstance()), Treasure2Integration.getInstance());
        SBItems.registerItem((IForgeRegistry<Item>)registry, "charm_frozen_lock", new ItemArtefactSB(EnumRarity.RARE, ItemArtefact.Type.CHARM, Treasure2Integration.getInstance()), Treasure2Integration.getInstance());
        SBItems.registerItem((IForgeRegistry<Item>)registry, "charm_wishing_well", new ItemCharmWishingWell(EnumRarity.UNCOMMON, ItemArtefact.Type.CHARM, Treasure2Integration.getInstance()), Treasure2Integration.getInstance());
        if (Treasure2Integration.getInstance().isEnabled()) {
            Treasure2Objects.registerItems(event);
        }
    }

    @Nonnull
    private static <T> T placeholder() {
        return null;
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, ItemArtefact item, Integration integration) {
        SBItems.registerItem(registry, name, (Item)item, false);
        integration.addArtefact((Item)item);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, Item item) {
        SBItems.registerItem(registry, name, item, false);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, String modid, Item item) {
        SBItems.registerItem(registry, name, modid, item, false);
    }

    public static void registerItem(IForgeRegistry<Item> registry, String name, Item item, boolean setTabIcon) {
        item.setRegistryName("spellbundle", name);
        item.func_77655_b(item.getRegistryName().toString());
        registry.register((IForgeRegistryEntry)item);
        if (setTabIcon && item.func_77640_w() instanceof WizardryTabs.CreativeTabSorted) {
            ((WizardryTabs.CreativeTabSorted)item.func_77640_w()).setIconItem(new ItemStack(item));
        }
        if (item.func_77640_w() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)item.func_77640_w()).order.add(item);
        }
    }

    public static void registerItem(IForgeRegistry<Item> registry, String modid, String name, Item item, boolean setTabIcon) {
        item.setRegistryName(modid, name);
        item.func_77655_b(item.getRegistryName().toString());
        registry.register((IForgeRegistryEntry)item);
        if (setTabIcon && item.func_77640_w() instanceof WizardryTabs.CreativeTabSorted) {
            ((WizardryTabs.CreativeTabSorted)item.func_77640_w()).setIconItem(new ItemStack(item));
        }
        if (item.func_77640_w() instanceof WizardryTabs.CreativeTabListed) {
            ((WizardryTabs.CreativeTabListed)item.func_77640_w()).order.add(item);
        }
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block) {
        Item itemblock = (Item)new ItemBlock(block).setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)itemblock);
    }

    public static void registerItemBlock(IForgeRegistry<Item> registry, Block block, Item itemblock) {
        itemblock.setRegistryName(block.getRegistryName());
        registry.register((IForgeRegistryEntry)itemblock);
    }
}

