/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.integration.waystones;

import com.windanesz.spellbundle.Settings;
import com.windanesz.spellbundle.integration.Integration;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;

public class WaystonesIntegration
extends Integration {
    private static final WaystonesIntegration instance = new WaystonesIntegration();
    private static final String modId = "waystones";
    private static final List<Spell> SPELL_LIST = new ArrayList<Spell>();
    private static final List<Item> ARTEFACT_LIST = new ArrayList<Item>();
    private boolean isLoaded;

    private WaystonesIntegration() {
    }

    public static Integration getInstance() {
        return instance;
    }

    @Override
    public String getModid() {
        return modId;
    }

    @Override
    public void init() {
        Integration.register(this.getModid(), WaystonesIntegration.getInstance());
        this.isLoaded = Loader.isModLoaded((String)this.getModid());
        if (!this.isEnabled()) {
            return;
        }
        this.initCustom();
    }

    @Override
    public boolean isEnabled() {
        return Settings.generalSettings.waystones_integration && this.isLoaded;
    }

    @Override
    public List<Spell> getSpells() {
        return SPELL_LIST;
    }

    @Override
    public Spell addSpell(Spell spell) {
        if (!SPELL_LIST.contains(spell)) {
            SPELL_LIST.add(spell);
        }
        return spell;
    }

    @Override
    public List<Item> getArtefacts() {
        return ARTEFACT_LIST;
    }

    @Override
    public void addArtefact(Item item) {
        ARTEFACT_LIST.add(item);
    }

    private void initCustom() {
    }

    @Override
    public String getMissingSpellDesc() {
        return "spell.spellbundle:waystones_missing";
    }
}

