/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.integration.treasure2;

import com.windanesz.spellbundle.Settings;
import com.windanesz.spellbundle.integration.Integration;
import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;

public class Treasure2Integration
extends Integration {
    private static final Treasure2Integration instance = new Treasure2Integration();
    private static final String modId = "treasure2";
    private static final List<Spell> SPELL_LIST = new ArrayList<Spell>();
    private static final List<Item> ARTEFACT_LIST = new ArrayList<Item>();
    private boolean isLoaded;

    private Treasure2Integration() {
    }

    public static Integration getInstance() {
        return instance;
    }

    @Override
    public String getModid() {
        return modId;
    }

    @Override
    public void init() {
        Integration.register(this.getModid(), Treasure2Integration.getInstance());
        this.isLoaded = Loader.isModLoaded((String)this.getModid());
        if (!this.isEnabled()) {
            return;
        }
        this.initCustom();
    }

    @Override
    public boolean isEnabled() {
        return Settings.generalSettings.treasure2_integration && this.isLoaded;
    }

    @Override
    public List<Spell> getSpells() {
        return SPELL_LIST;
    }

    @Override
    public Spell addSpell(Spell spell) {
        if (!SPELL_LIST.contains(spell)) {
            SPELL_LIST.add(spell);
        }
        return spell;
    }

    @Override
    public List<Item> getArtefacts() {
        return ARTEFACT_LIST;
    }

    @Override
    public void addArtefact(Item item) {
        ARTEFACT_LIST.add(item);
    }

    private void initCustom() {
    }

    @Override
    public String getMissingSpellDesc() {
        return "spell.spellbundle:treasure2_missing";
    }
}

