/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle.capability;

import com.google.common.base.Predicate;
import com.windanesz.spellbundle.SpellBundle;
import com.windanesz.spellbundle.entity.ai.EntityAIMinionOwnerHurtByTarget;
import com.windanesz.spellbundle.entity.ai.EntityAIMinionOwnerHurtTarget;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class SummonedCreatureData
implements INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=SummonedCreatureData.class)
    private static final Capability<SummonedCreatureData> SUMMONED_CREATURE_DATA_CAPABILITY = null;
    private final EntityLivingBase minion;
    private int lifetime = -1;
    private boolean summoned = false;
    private UUID casterUUID;
    private UUID owner;

    public SummonedCreatureData() {
        this(null);
    }

    public SummonedCreatureData(EntityLivingBase entity) {
        this.minion = entity;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(SummonedCreatureData.class, (Capability.IStorage)new Capability.IStorage<SummonedCreatureData>(){

            public NBTBase writeNBT(Capability<SummonedCreatureData> capability, SummonedCreatureData instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<SummonedCreatureData> capability, SummonedCreatureData instance, EnumFacing side, NBTBase nbt) {
            }
        }, SummonedCreatureData::new);
    }

    public static SummonedCreatureData get(EntityLivingBase entity) {
        return (SummonedCreatureData)entity.getCapability(SUMMONED_CREATURE_DATA_CAPABILITY, null);
    }

    public static boolean isSummonedEntity(Entity entity) {
        return entity instanceof EntityCreature && SummonedCreatureData.get((EntityLivingBase)((EntityCreature)entity)) != null && SummonedCreatureData.get((EntityLivingBase)((EntityCreature)entity)).summoned;
    }

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityCreature) {
            event.addCapability(new ResourceLocation("spellbundle", "SummonedCreatureData"), (ICapabilityProvider)new Provider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            EntityLiving entity = (EntityLiving)event.getEntity();
            SummonedCreatureData data = SummonedCreatureData.get((EntityLivingBase)entity);
            data.updateEntityTargetTasks((EntityCreature)entity);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            SummonedCreatureData.get((EntityLivingBase)((EntityCreature)event.getEntity())).updateDelegate();
        }
    }

    @SubscribeEvent
    public static void onLivingDropsEvent(LivingDropsEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (SummonedCreatureData.isSummonedEntity(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    public void updateEntityTargetTasks(EntityCreature minion) {
        while (minion.field_70715_bh.field_75782_a.stream().anyMatch(taskEntry -> taskEntry.field_75733_a != null)) {
            minion.field_70715_bh.field_75782_a.stream().filter(taskEntry -> taskEntry.field_75733_a != null).findFirst().ifPresent(taskEntry -> minion.field_70715_bh.func_85156_a(taskEntry.field_75733_a));
        }
        minion.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIMinionOwnerHurtByTarget(minion));
        minion.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIMinionOwnerHurtTarget(minion));
        minion.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget(minion, false, new Class[0]));
        minion.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget(minion, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    private Predicate<Entity> getTargetSelector() {
        return entity -> !entity.func_82150_aj() && (this.getCaster() == null ? entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_() : this.isValidTarget((Entity)entity));
    }

    private boolean isValidTarget(Entity target) {
        if (AllyDesignationSystem.isValidTarget((Entity)this.getCaster(), (Entity)target)) {
            SummonedCreatureData data;
            if (target instanceof EntityLivingBase && SummonedCreatureData.isSummonedEntity(target) && ((data = SummonedCreatureData.get((EntityLivingBase)target)).getCaster() != null && data.getCaster() == this.getCaster() || AllyDesignationSystem.isAllied((EntityLivingBase)data.getCaster(), (EntityLivingBase)this.getCaster()))) {
                return false;
            }
            if (target instanceof EntityPlayer) {
                return !(this.getCaster() instanceof EntityWizard) || this.getCaster().func_70643_av() == target || ((EntityWizard)this.getCaster()).func_70638_az() == target;
            }
            if ((target instanceof IMob || target instanceof ISummonedCreature || target instanceof EntityWizard && !(this.getCaster() instanceof EntityWizard) || target instanceof EntityLiving && ((EntityLiving)target).func_70638_az() == this.getCaster() || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(target.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(target.getClass()))) {
                return true;
            }
        }
        return false;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
        if (!this.summoned) {
            this.summoned = true;
        }
    }

    public UUID getOwnerId() {
        return this.casterUUID;
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    public EntityLivingBase getCaster() {
        Entity caster = EntityUtils.getEntityByUUID((World)this.minion.field_70170_p, (UUID)this.getOwnerId());
        if (caster != null && !(caster instanceof EntityLivingBase)) {
            SpellBundle.logger.warn("{} has a non-living owner!", (Object)this);
            return null;
        }
        return (EntityLivingBase)caster;
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.setOwnerId(caster == null ? null : caster.func_110124_au());
        if (!this.summoned) {
            this.summoned = true;
        }
    }

    void updateDelegate() {
        if (!this.summoned) {
            return;
        }
        if (this.minion.field_70173_aa > this.getLifetime() && this.getLifetime() > 0) {
            this.minion.func_70106_y();
        }
        if (this.minion.field_70170_p.field_72995_K && this.minion.field_70170_p.field_73012_v.nextInt(8) == 0) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(this.minion.field_70165_t, this.minion.field_70163_u + this.minion.field_70170_p.field_73012_v.nextDouble() * 1.5, this.minion.field_70161_v).clr(0.1f, 0.0f, 0.0f).spawn(this.minion.field_70170_p);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.summoned) {
            nbt.func_74757_a("summoned", true);
            if (this.getOwnerId() != null) {
                NBTTagCompound casterUUID = new NBTTagCompound();
                casterUUID.func_186854_a("casterUUID", this.getOwnerId());
                nbt.func_74782_a("casterUUID", (NBTBase)casterUUID);
            }
            if (this.lifetime != -1) {
                nbt.func_74768_a("lifetime", this.getLifetime());
            }
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null && !nbt.func_82582_d() && nbt.func_74764_b("summoned")) {
            if (nbt.func_74764_b("casterUUID")) {
                this.setOwnerId(nbt.func_74775_l("casterUUID").func_186857_a("casterUUID"));
            }
            if (nbt.func_74764_b("lifetime")) {
                this.setLifetime(nbt.func_74762_e("lifetime"));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        private final SummonedCreatureData data;

        public Provider(EntityLivingBase entity) {
            this.data = new SummonedCreatureData(entity);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == SUMMONED_CREATURE_DATA_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == SUMMONED_CREATURE_DATA_CAPABILITY) {
                return (T)SUMMONED_CREATURE_DATA_CAPABILITY.cast((Object)this.data);
            }
            return null;
        }

        public NBTTagCompound serializeNBT() {
            return this.data.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            this.data.deserializeNBT(nbt);
        }
    }
}

