/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.spellbundle;

import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.ItemArtefact;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="spellbundle", name="SpellBundle")
public class Settings {
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.spellbundle:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();
    @Config.Name(value="Spell Tweaks Settings")
    @Config.LangKey(value="settings.spellbundle:spell_tweaks")
    public static SpellTweaksSettings spellTweaksSettings = new SpellTweaksSettings();

    public static boolean isArtefactEnabled(Item artefact) {
        if (artefact instanceof ItemArtefact && Wizardry.settings.getConfigCategory("artefacts").containsKey(artefact.getRegistryName().toString())) {
            return Wizardry.settings.getConfigCategory("artefacts").get(artefact.getRegistryName().toString()).getBoolean();
        }
        return true;
    }

    public static class SpellTweaksSettings {
        @Config.Name(value="[WAYSTONES MOD] Blacklisted warp entities for Warpstone Ring")
        @Config.Comment(value={"Add entities in a modid:registryname format to disallow teleporting them with Warpstone Ring + (Mass) Warp"})
        @Config.RequiresMcRestart
        public String[] warp_entity_blacklist = new String[]{"ebwizardry:wizard", "ebwizardry:evil_wizard"};
    }

    public static class GeneralSettings {
        @Config.Name(value="Waystones integration")
        @Config.Comment(value={"Enables or disables the Waystones integration"})
        @Config.RequiresMcRestart
        public boolean waystones_integration = true;
        @Config.Name(value="Treasure2 integration")
        @Config.Comment(value={"Enables or disables the Treasure2 integration"})
        @Config.RequiresMcRestart
        public boolean treasure2_integration = true;
        @Config.Name(value="Baubles Integration")
        @Config.Comment(value={"Enable/Disable Baubles integration for the new artefact types (belt, helm, etc). This does NOT affect Electroblob's Wizardry's own Baubles support implementation (ring, amulet, charm)!"})
        @Config.RequiresMcRestart
        public boolean baubles_integration = true;
    }

    @Mod.EventBusSubscriber(modid="spellbundle")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("spellbundle")) {
                ConfigManager.sync((String)"spellbundle", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

