/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.network;

import io.netty.buffer.ByteBuf;
import mrriegel.storagenetwork.block.TileConnectable;
import mrriegel.storagenetwork.data.EnumSortType;
import mrriegel.storagenetwork.gui.IStorageContainer;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SortMessage
implements IMessage,
IMessageHandler<SortMessage, IMessage> {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;

    public SortMessage() {
    }

    public SortMessage(BlockPos pos, boolean direction, EnumSortType sort) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
    }

    public IMessage onMessage(final SortMessage message, MessageContext ctx) {
        final EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
        WorldServer mainThread = (WorldServer)player.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (player.field_71070_bA instanceof IStorageContainer) {
                    if (((IStorageContainer)player.field_71070_bA).isRequest()) {
                        TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
                        if (tileEntity instanceof TileConnectable) {
                            TileConnectable tile = (TileConnectable)tileEntity;
                            tile.setSort(message.sort);
                            tile.setDownwards(message.direction);
                        }
                        tileEntity.func_70296_d();
                    } else {
                        ItemStack stackPlayerHeld = player.field_71071_by.func_70448_g();
                        NBTHelper.setBoolean(stackPlayerHeld, "down", message.direction);
                        NBTHelper.setString(stackPlayerHeld, "sort", message.sort.toString());
                        return;
                    }
                }
            }
        });
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.direction = buf.readBoolean();
        this.sort = EnumSortType.valueOf(ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.direction);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.sort.toString());
    }
}

