/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.item.remote;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mrriegel.storagenetwork.StorageNetwork;
import mrriegel.storagenetwork.block.master.TileMaster;
import mrriegel.storagenetwork.gui.ContainerNetworkBase;
import mrriegel.storagenetwork.gui.InventoryCraftingNetwork;
import mrriegel.storagenetwork.item.remote.ItemRemote;
import mrriegel.storagenetwork.item.remote.RemoteType;
import mrriegel.storagenetwork.network.StackRefreshClientMessage;
import mrriegel.storagenetwork.registry.PacketRegistry;
import mrriegel.storagenetwork.util.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerRemote
extends ContainerNetworkBase {
    private final ItemStack remoteItemStack;
    private final EnumHand hand;

    public ContainerRemote(InventoryPlayer playerInv, EnumHand hand) {
        this.playerInv = playerInv;
        this.result = new InventoryCraftResult();
        this.remoteItemStack = playerInv.field_70458_d.func_184586_b(hand);
        this.isSimple = this.getItemRemote().func_77960_j() == RemoteType.SIMPLE.ordinal();
        ArrayList<ItemStack> storage = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            storage.add(NBTHelper.getItemStack(this.remoteItemStack, "c" + i));
        }
        if (!this.isSimple) {
            this.matrix = new InventoryCraftingNetwork((Container)this, storage);
            ContainerNetworkBase.SlotCraftingNetwork slotCraftOutput = new ContainerNetworkBase.SlotCraftingNetwork(playerInv.field_70458_d, this.matrix, (IInventory)this.result, 0, 101, 128);
            slotCraftOutput.setTileMaster(this.getTileMaster());
            this.func_75146_a((Slot)slotCraftOutput);
            this.bindGrid();
        }
        this.bindPlayerInvo(playerInv);
        this.bindHotbar();
        if (this.matrix != null) {
            this.func_75130_a((IInventory)this.matrix);
        }
        this.hand = hand;
    }

    @Nonnull
    public ItemStack getItemRemote() {
        if (!(this.remoteItemStack.func_77973_b() instanceof ItemRemote)) {
            return ItemStack.field_190927_a;
        }
        return this.remoteItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(List<ItemStack> listIn) {
        if (this.matrix != null) {
            this.matrix.skipEvents = true;
        }
        for (int i = 0; i < listIn.size(); ++i) {
            this.func_75139_a(i).func_75215_d(listIn.get(i));
        }
        if (this.matrix != null) {
            this.matrix.skipEvents = false;
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        TileMaster tileMaster = this.getTileMaster();
        if (tileMaster == null) {
            StorageNetwork.log("ContainerRemote closing, master tile not found " + this.remoteItemStack);
            return false;
        }
        if (!playerIn.field_70170_p.field_72995_K && playerIn.field_70170_p.func_82737_E() % 40L == 0L) {
            List<ItemStack> list = tileMaster.getStacks();
            PacketRegistry.INSTANCE.sendTo((IMessage)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), (EntityPlayerMP)playerIn);
        }
        return playerIn.func_184586_b(this.hand) == this.remoteItemStack;
    }

    @Override
    public void slotChanged() {
        if (this.matrix != null) {
            for (int i = 0; i < 9; ++i) {
                NBTHelper.setItemStack(this.remoteItemStack, "c" + i, this.matrix.func_70301_a(i));
            }
        }
    }

    @Override
    public void func_75130_a(IInventory inventoryIn) {
        this.findMatchingRecipe(this.matrix);
    }

    @Override
    public TileMaster getTileMaster() {
        return ItemRemote.getTile(this.remoteItemStack);
    }

    @Override
    public void bindHotbar() {
        for (int i = 0; i < 9; ++i) {
            if (i == this.playerInv.field_70461_c) {
                this.func_75146_a(new Slot((IInventory)this.playerInv, i, 8 + i * 18, 232){

                    public boolean func_75214_a(ItemStack stack) {
                        return false;
                    }

                    public boolean func_82869_a(EntityPlayer playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.func_75146_a(new Slot((IInventory)this.playerInv, i, 8 + i * 18, 232));
        }
    }

    @Override
    public boolean isRequest() {
        return false;
    }
}

