/*
 * Decompiled with CFR 0.152.
 */
package mrriegel.storagenetwork.block.cable.io;

import javax.annotation.Nullable;
import mrriegel.storagenetwork.api.capability.IConnectableItemAutoIO;
import mrriegel.storagenetwork.api.data.DimPos;
import mrriegel.storagenetwork.api.data.EnumStorageDirection;
import mrriegel.storagenetwork.block.cable.BlockCableWithFacing;
import mrriegel.storagenetwork.block.cable.io.TileCableIO;
import mrriegel.storagenetwork.capabilities.CapabilityConnectableAutoIO;
import mrriegel.storagenetwork.capabilities.StorageNetworkCapabilities;
import mrriegel.storagenetwork.util.UtilTileEntity;
import mrriegel.storagenetwork.util.inventory.UpgradesItemStackHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockCableIO
extends BlockCableWithFacing {
    private EnumStorageDirection storageDirection;

    public BlockCableIO(String registryName, EnumStorageDirection storageDirection) {
        super(registryName);
        this.storageDirection = storageDirection;
    }

    @Override
    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCableIO(this.storageDirection);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        DimPos breakPos = new DimPos(worldIn, pos);
        TileCableIO tile = breakPos.getTileEntity(TileCableIO.class);
        if (tile == null) {
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        IConnectableItemAutoIO iConnectable = breakPos.getCapability(StorageNetworkCapabilities.CONNECTABLE_AUTO_IO, null);
        if (iConnectable == null || !(iConnectable instanceof CapabilityConnectableAutoIO)) {
            super.func_180663_b(worldIn, pos, state);
            return;
        }
        UpgradesItemStackHandler upgrades = ((CapabilityConnectableAutoIO)iConnectable).upgrades;
        for (ItemStack stack : upgrades.getStacks()) {
            UtilTileEntity.spawnItemStack(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
        }
        worldIn.func_175666_e(pos, (Block)this);
        super.func_180663_b(worldIn, pos, state);
    }
}

