/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.energy.EnergyStorageScanner;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;

public final class CapabilityProviderItemScanner
implements ICapabilityProvider {
    private final ItemHandlerScanner itemHandler;
    private final EnergyStorageScanner energyStorage;

    public CapabilityProviderItemScanner(ItemStack container) {
        this.itemHandler = new ItemHandlerScanner(container);
        this.energyStorage = new EnergyStorageScanner(container);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return Settings.useEnergy() && capability == CapabilityEnergy.ENERGY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.itemHandler.updateFromNBT();
            return (T)((Object)this.itemHandler);
        }
        if (Settings.useEnergy() && capability == CapabilityEnergy.ENERGY) {
            this.energyStorage.updateFromNBT();
            return (T)((Object)this.energyStorage);
        }
        return null;
    }
}

