/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModPotions;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.modifiers.Cost;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.Modifier;
import epicsquid.roots.modifiers.ModifierCores;
import epicsquid.roots.modifiers.ModifierRegistry;
import epicsquid.roots.modifiers.instance.staff.StaffModifierInstanceList;
import epicsquid.roots.properties.Property;
import epicsquid.roots.spell.SpellBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreIngredient;

public class SpellStormCloud
extends SpellBase {
    public static Property.PropertyCooldown PROP_COOLDOWN = new Property.PropertyCooldown(100);
    public static Property.PropertyCastType PROP_CAST_TYPE = new Property.PropertyCastType(SpellBase.EnumCastType.INSTANTANEOUS);
    public static Property.PropertyCost PROP_COST_1 = new Property.PropertyCost(new SpellBase.SpellCost("cloud_berry", 0.25));
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(600).setDescription("the duration of the spell effect on the player");
    public static Property<Integer> PROP_RADIUS = new Property<Integer>("radius", 2).setDescription("the radius of the area covered by the spring storm");
    public static Property<Integer> PROP_RADIUS_EXTENDED = new Property<Integer>("extended_radius", 2).setDescription("the additional radius of the storm");
    public static Property<Float> PROP_LIGHTNING_CHANCE = new Property<Float>("lightning_chance", Float.valueOf(0.25f)).setDescription("chance for each lightning to spawn");
    public static Property<Integer> PROP_LIGHTNING_INTERVAL = new Property<Integer>("lightning_interval", 60).setDescription("frequency that checks for lightning strikes are made");
    public static Property<Integer> PROP_FIRE_RESISTANCE = new Property<Integer>("fire_resistance", 2).setDescription("the level of fire resistance given entities for the duration");
    public static Property<Float> PROP_LIGHTNING_DAMAGE = new Property<Float>("lightning_damage", Float.valueOf(2.5f)).setDescription("the amount of damage done when struck while in the storm");
    public static Property<Integer> PROP_HEAL_INTERVAL = new Property<Integer>("heal_interval", 100).setDescription("the interval between each heal");
    public static Property<Float> PROP_HEAL_AMOUNT = new Property<Float>("heal_amount", Float.valueOf(1.0f)).setDescription("how much healing should be done");
    public static Property<Integer> PROP_POISON_DURATION = new Property<Integer>("poison_duration", 60).setDescription("the duration of the poison effect when applied to creatures");
    public static Property<Integer> PROP_POISON_AMPLIFIER = new Property<Integer>("poison_amplifier", 0).setDescription("the amplifier that should be used for the poison effect");
    public static Property<Float> PROP_ICICLE_DAMAGE = new Property<Float>("icicle_damage", Float.valueOf(2.5f)).setDescription("how much damage icicles should do to an entity");
    public static Property<Float> PROP_ICICLE_CHANCE = new Property<Float>("icicle_chance", Float.valueOf(0.25f)).setDescription("the chance of a icicle spawning every icicle interval");
    public static Property<Integer> PROP_ICICLE_INTERVAL = new Property<Integer>("icicle_interval", 70).setDescription("the interval between attempting to spawn icicles");
    public static Modifier RADIUS = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "spread"), ModifierCores.PERESKIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.PERESKIA, 0.275)));
    public static Modifier PEACEFUL = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "peaceful_storm"), ModifierCores.WILDEWHEET, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDEWHEET, 0.125)));
    public static Modifier MAGNETISM = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "magnetic_storm"), ModifierCores.WILDROOT, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.WILDROOT, 0.345)));
    public static Modifier LIGHTNING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "lightning_strikes"), ModifierCores.MOONGLOW_LEAF, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.MOONGLOW_LEAF, 0.65)));
    public static Modifier JOLT = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "reactive_jolt"), ModifierCores.SPIRIT_HERB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.SPIRIT_HERB, 0.345)));
    public static Modifier HEALING = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "healing_rain"), ModifierCores.TERRA_MOSS, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.TERRA_MOSS, 0.345)));
    public static Modifier POISON = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "poison_storm"), ModifierCores.BAFFLE_CAP, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.BAFFLE_CAP, 0.345)));
    public static Modifier OBSIDIAN = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "ignification"), ModifierCores.INFERNAL_BULB, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.INFERNAL_BULB, 0.345)));
    public static Modifier ICICLES = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "icicles"), ModifierCores.STALICRIPE, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.STALICRIPE, 0.45)));
    public static Modifier ICE = ModifierRegistry.register(new Modifier(new ResourceLocation("roots", "freezing_rain"), ModifierCores.DEWGONIA, Cost.single(CostType.ADDITIONAL_COST, ModifierCores.DEWGONIA, 0.275)));
    public static ResourceLocation spellName = new ResourceLocation("roots", "spell_storm_cloud");
    public static SpellStormCloud instance = new SpellStormCloud(spellName);
    public float lightning_damage;
    public float heal_amount;
    public float icicle_damage;
    public float lightning_chance;
    public float icicle_chance;
    public int radius;
    public int duration;
    public int fire_resistance;
    public int lightning_interval;
    public int radius_extended;
    public int heal_interval;
    public int poison_duration;
    public int poison_amplifier;
    public int icicle_interval;

    public SpellStormCloud(ResourceLocation name) {
        super(name, TextFormatting.DARK_AQUA, 0.08627451f, 0.5568628f, 1.0f, 1.0f, 1.0f, 1.0f);
        this.properties.add(PROP_COOLDOWN, PROP_CAST_TYPE, PROP_COST_1, PROP_DURATION, PROP_RADIUS, PROP_RADIUS_EXTENDED, PROP_LIGHTNING_CHANCE, PROP_LIGHTNING_DAMAGE, PROP_LIGHTNING_INTERVAL, PROP_FIRE_RESISTANCE, PROP_HEAL_AMOUNT, PROP_HEAL_INTERVAL, PROP_POISON_AMPLIFIER, PROP_POISON_DURATION, PROP_ICICLE_DAMAGE, PROP_ICICLE_CHANCE, PROP_ICICLE_INTERVAL);
        this.acceptModifiers(RADIUS, PEACEFUL, MAGNETISM, LIGHTNING, JOLT, HEALING, POISON, OBSIDIAN, ICICLES, ICE);
    }

    @Override
    public void init() {
        this.addIngredients(new ItemStack(ModItems.dewgonia), new ItemStack(Items.field_151131_as), new OreIngredient("sugarcane"), new ItemStack(Items.field_151119_aD), new ItemStack(Item.func_150898_a((Block)Blocks.field_150328_O), 1, BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()));
        this.setCastSound(ModSounds.Spells.STORM_CLOUD);
    }

    @Override
    public boolean cast(EntityPlayer player, StaffModifierInstanceList info, int ticks) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            player.func_70690_d(new PotionEffect(ModPotions.storm_cloud, this.duration, 0, false, false));
            player.getEntityData().func_74783_a(this.getCachedName(), info.toArray());
        }
        return true;
    }

    @Override
    public void doFinalise() {
        this.castType = this.properties.get(PROP_CAST_TYPE);
        this.cooldown = this.properties.get(PROP_COOLDOWN);
        this.duration = this.properties.get(PROP_DURATION);
        this.radius = this.properties.get(PROP_RADIUS);
        this.fire_resistance = this.properties.get(PROP_FIRE_RESISTANCE);
        this.lightning_chance = this.properties.get(PROP_LIGHTNING_CHANCE).floatValue();
        this.lightning_interval = this.properties.get(PROP_LIGHTNING_INTERVAL);
        this.radius_extended = this.properties.get(PROP_RADIUS_EXTENDED);
        this.lightning_damage = this.properties.get(PROP_LIGHTNING_DAMAGE).floatValue();
        this.heal_amount = this.properties.get(PROP_HEAL_AMOUNT).floatValue();
        this.poison_amplifier = this.properties.get(PROP_POISON_AMPLIFIER);
        this.poison_duration = this.properties.get(PROP_POISON_DURATION);
        this.icicle_damage = this.properties.get(PROP_ICICLE_DAMAGE).floatValue();
        this.icicle_interval = this.properties.get(PROP_ICICLE_INTERVAL);
        this.heal_interval = this.properties.get(PROP_HEAL_INTERVAL);
        this.icicle_chance = this.properties.get(PROP_ICICLE_CHANCE).floatValue();
    }
}

