/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.ritual;

import epicsquid.roots.entity.ritual.EntityRitualDivineProtection;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.properties.Property;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.conditions.ConditionStandingStones;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.oredict.OreIngredient;

public class RitualDivineProtection
extends RitualBase {
    public static Property.PropertyDuration PROP_DURATION = new Property.PropertyDuration(1200);
    public static Property<Boolean> PROP_RAIN = new Property<Boolean>("rain", true).setDescription("whether or not rain should be disabled");
    public static Property<Boolean> PROP_TIME = new Property<Boolean>("time", true).setDescription("whether or not time should be accelerated or slowed");
    public static Property<Integer> PROP_NIGHT_REDUCTION = new Property<Integer>("night_reduction", 1).setDescription("the number of additional ticks (per tick) added to night");
    public static Property<Float> PROP_DAY_EXTENSION = new Property<Float>("day_extension", Float.valueOf(0.3f)).setDescription("the chance per tick that ticks will be subtracted, lengthening the day");
    public static Property<Float> PROP_CONSECRATION_DAMAGE = new Property<Float>("consecration_damage", Float.valueOf(4.0f)).setDescription("damage done to undead creatures if Consecration is installed");
    public static Property<Float> PROP_FIRE_DAMAGE = new Property<Float>("fire_damage", Float.valueOf(4.0f)).setDescription("amount of fire damage done to undead creatures");
    public static Property<Integer> PROP_FIRE_DURATION = new Property<Integer>("fire_duration", 2).setDescription("duration in SECONDS undead creatures will be set on fire for");
    public static Property<Integer> PROP_RADIUS_X = new Property<Integer>("radius_x", 15).setDescription("Radius on the X Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Y = new Property<Integer>("radius_y", 15).setDescription("Radius on the Y Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_RADIUS_Z = new Property<Integer>("radius_z", 15).setDescription("Radius on the Z Axis of the cube in which the ritual takes place");
    public static Property<Integer> PROP_DAY_LENGTH = new Property<Integer>("day_length", 24000).setDescription("the length of the day for use in calculating addition/subtraction (modify if you have mods that adjust day/night length");
    public static Property<Integer> PROP_NIGHT_THRESHOLD = new Property<Integer>("night_threshold", 12000).setDescription("the point at which day transitions into night (modify if you have mods that adjust day/night length");
    public boolean rain;
    public boolean time;
    public float radius_x;
    public float radius_y;
    public float radius_z;
    public float consecration_damage;
    public float fire_damage;
    public int night_reduction;
    public int fire_duration;
    public int day_length;
    public int night_threshold;
    public float day_extension;

    public RitualDivineProtection(String name, boolean disabled) {
        super(name, disabled);
        this.properties.add(PROP_DURATION, PROP_RAIN, PROP_TIME, PROP_NIGHT_REDUCTION, PROP_DAY_EXTENSION, PROP_CONSECRATION_DAMAGE, PROP_FIRE_DAMAGE, PROP_FIRE_DURATION, PROP_RADIUS_X, PROP_RADIUS_Y, PROP_RADIUS_Z, PROP_DAY_LENGTH, PROP_NIGHT_THRESHOLD);
        this.setEntityClass(EntityRitualDivineProtection.class);
    }

    @Override
    public void init() {
        this.recipe = new RitualBase.RitualRecipe((RitualBase)this, new ItemStack(ModItems.pereskia), new ItemStack(ModItems.cloud_berry), new OreIngredient("rootsBark"), new ItemStack(ModItems.bark_oak), new OreIngredient("dustGlowstone"));
        this.addCondition(new ConditionStandingStones(3, 1));
        this.setIcon(ModItems.ritual_divine_protection);
        this.setColor(TextFormatting.YELLOW);
        this.setBold(true);
    }

    @Override
    public void doFinalise() {
        this.duration = this.properties.get(PROP_DURATION);
        this.rain = this.properties.get(PROP_RAIN);
        this.time = this.properties.get(PROP_TIME);
        this.night_reduction = this.properties.get(PROP_NIGHT_REDUCTION);
        this.day_extension = this.properties.get(PROP_DAY_EXTENSION).floatValue();
        this.consecration_damage = this.properties.get(PROP_CONSECRATION_DAMAGE).floatValue();
        this.fire_damage = this.properties.get(PROP_FIRE_DAMAGE).floatValue();
        this.fire_duration = this.properties.get(PROP_FIRE_DURATION);
        int[] radius = this.properties.getRadius();
        this.radius_x = (float)radius[0] + 0.5f;
        this.radius_y = (float)radius[1] + 0.5f;
        this.radius_z = (float)radius[2] + 0.5f;
        this.day_length = this.properties.get(PROP_DAY_LENGTH);
        this.night_threshold = this.properties.get(PROP_NIGHT_THRESHOLD);
    }
}

