/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.roots.network.ClientMessageHandler;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.spell.SpellExtension;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSenseFX
implements IMessage {
    private HashMap<SpellExtension.SenseType, List<BlockPos>> senses;

    public MessageSenseFX() {
    }

    public MessageSenseFX(HashMap<SpellExtension.SenseType, List<BlockPos>> senses) {
        this.senses = senses;
    }

    public void fromBytes(ByteBuf buf) {
        this.senses = new HashMap();
        for (SpellExtension.SenseType type : SpellExtension.SenseType.values()) {
            List positions = this.senses.computeIfAbsent(type, t -> new ArrayList());
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                positions.add(new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        for (SpellExtension.SenseType type : SpellExtension.SenseType.values()) {
            List<BlockPos> positions = this.senses.get((Object)type);
            if (positions == null) {
                buf.writeInt(0);
                continue;
            }
            buf.writeInt(positions.size());
            for (BlockPos pos : positions) {
                buf.writeInt(pos.func_177958_n());
                buf.writeInt(pos.func_177956_o());
                buf.writeInt(pos.func_177952_p());
            }
        }
    }

    public static class Handler
    extends ClientMessageHandler<MessageSenseFX> {
        @Override
        @SideOnly(value=Side.CLIENT)
        protected void handleMessage(MessageSenseFX message, MessageContext ctx) {
            Minecraft minecraft = Minecraft.func_71410_x();
            WorldClient world = minecraft.field_71441_e;
            for (SpellExtension.SenseType type : SpellExtension.SenseType.values()) {
                List positions = (List)message.senses.get((Object)type);
                if (positions == null) continue;
                for (BlockPos pos : positions) {
                    for (int i = 0; i < 2; ++i) {
                        ParticleUtil.spawnParticlePetal((World)world, (float)pos.func_177958_n() + (0.5f - world.field_73012_v.nextFloat()) + (float)(world.field_73012_v.nextInt(3) == 0 ? (world.field_73012_v.nextBoolean() ? -1 : 1) : 0), (float)pos.func_177956_o() + (0.5f - world.field_73012_v.nextFloat()) + (float)(world.field_73012_v.nextInt(3) == 0 ? (world.field_73012_v.nextBoolean() ? -1 : 1) : 0), (float)pos.func_177952_p() + (0.5f - world.field_73012_v.nextFloat()) + (float)(world.field_73012_v.nextInt(3) == 0 ? (world.field_73012_v.nextBoolean() ? -1 : 1) : 0), 0.0f, 0.0f, 0.0f, type.getColor(), 10.0f, 600, true);
                    }
                }
            }
        }
    }

    public static class SensePosition {
        private SpellExtension.SenseType type;
        private BlockPos pos;

        public SensePosition(SpellExtension.SenseType type, BlockPos pos) {
            this.type = type;
            this.pos = pos;
        }

        public SensePosition(SpellExtension.SenseType type, int x, int y, int z) {
            this.type = type;
            this.pos = new BlockPos(x, y, z);
        }

        public SpellExtension.SenseType getType() {
            return this.type;
        }

        public BlockPos getPos() {
            return this.pos;
        }
    }
}

