/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.modifiers;

import epicsquid.roots.api.Herb;
import epicsquid.roots.modifiers.CostType;
import epicsquid.roots.modifiers.IModifierCore;
import epicsquid.roots.modifiers.IModifierCost;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class Cost
implements IModifierCost {
    private final CostType cost;
    private final double value;
    private final IModifierCore herb;

    public Cost(CostType cost, double value, IModifierCore herb) {
        this.cost = cost;
        this.value = value;
        this.herb = herb;
        if (cost == CostType.ADDITIONAL_COST && herb == null) {
            throw new IllegalArgumentException("Modifier cannot be additional cost without a herb specified.");
        }
        if (cost != CostType.NO_COST && value == 0.0) {
            throw new IllegalArgumentException("Modifier cannot be a cost modifier or an additional cost with a value single zero.");
        }
    }

    public Cost(CostType cost, double value) {
        this(cost, value, null);
    }

    public Cost(CostType cost) {
        this(cost, 0.0, null);
    }

    @Override
    public CostType getCost() {
        return this.cost;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public Herb getHerb() {
        if (this.herb != null) {
            return this.herb.getHerb();
        }
        return null;
    }

    public static Map<CostType, IModifierCost> single(CostType cost, IModifierCore herb, double value) {
        HashMap<CostType, IModifierCost> map = new HashMap<CostType, IModifierCost>();
        map.put(cost, new Cost(cost, value, herb));
        return map;
    }

    public static Map<CostType, IModifierCost> single(CostType cost, double value) {
        return Cost.single(cost, null, value);
    }

    public static Map<CostType, IModifierCost> single(CostType cost) {
        return Cost.single(cost, null, 0.0);
    }

    public static IModifierCost cost(CostType cost, IModifierCore herb, double value) {
        return new Cost(cost, value, herb);
    }

    public static IModifierCost cost(CostType cost, double value) {
        return Cost.cost(cost, null, value);
    }

    public static IModifierCost cost(CostType cost) {
        return Cost.cost(cost, null, 0.0);
    }

    public static Map<CostType, IModifierCost> of(IModifierCost ... costs) {
        HashMap<CostType, IModifierCost> map = new HashMap<CostType, IModifierCost>();
        for (IModifierCost cost : costs) {
            map.put(cost.getCost(), cost);
        }
        return map;
    }

    public static Map<CostType, IModifierCost> noCost() {
        return Cost.single(CostType.NO_COST);
    }
}

