/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei.soil;

import epicsquid.roots.config.ElementalSoilConfig;
import epicsquid.roots.integration.jei.soil.SoilCategory;
import epicsquid.roots.integration.jei.soil.SoilRecipe;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class SoilWrapper
implements IRecipeWrapper {
    public SoilRecipe recipe;
    public static List<FluidStack> FLUIDS = Arrays.asList(new FluidStack(FluidRegistry.LAVA, 1000), new FluidStack(FluidRegistry.WATER, 1000));

    public SoilWrapper(SoilRecipe recipe) {
        this.recipe = recipe;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fr = minecraft.field_71466_p;
        switch (this.recipe.getType()) {
            case WATER: 
            case FIRE: {
                SoilCategory.liquid.draw(minecraft, 15, 23);
                break;
            }
            case AIR: {
                fr.func_175063_a(I18n.func_135052_a((String)"jei.roots.soil.above", (Object[])new Object[0]), 79.0f, 0.0f, 0xFFFFFF);
                fr.func_175063_a("Y" + ElementalSoilConfig.AirSoilMinY, 79.0f, 12.0f, 0xFFFFFF);
                fr.func_175063_a(I18n.func_135052_a((String)"jei.roots.soil.delay", (Object[])new Object[0]), 79.0f, 24.0f, 0xFFFFFF);
                fr.func_175063_a(String.format("%.01f", (double)ElementalSoilConfig.AirSoilDelay / 20.0) + "s", 79.0f, 36.0f, 0xFFFFFF);
                SoilCategory.air.draw(minecraft, 15, 23);
                break;
            }
            case EARTH: {
                fr.func_175063_a(I18n.func_135052_a((String)"jei.roots.soil.below", (Object[])new Object[0]), 79.0f, 0.0f, 0xFFFFFF);
                fr.func_175063_a("Y" + ElementalSoilConfig.EarthSoilMaxY, 79.0f, 12.0f, 0xFFFFFF);
                fr.func_175063_a(I18n.func_135052_a((String)"jei.roots.soil.delay", (Object[])new Object[0]), 79.0f, 24.0f, 0xFFFFFF);
                fr.func_175063_a(String.format("%.01f", (double)ElementalSoilConfig.EarthSoilDelay / 20.0) + "s", 79.0f, 36.0f, 0xFFFFFF);
                SoilCategory.earth.draw(minecraft, 15, 23);
            }
        }
    }

    public void getIngredients(IIngredients ingredients) {
        if (this.recipe != null) {
            ingredients.setInput(VanillaTypes.ITEM, (Object)this.recipe.getSoil());
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getOutput());
            ingredients.setInputs(VanillaTypes.FLUID, FLUIDS);
        }
    }
}

