/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import epicsquid.mysticallib.util.ConfigUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Config;

@Config.LangKey(value="config.roots.category.moss")
@Config(modid="roots", name="roots/moss", category="moss")
public class MossConfig {
    @Config.Comment(value={"List of dimension IDs where terra moss harvesting shouldn't work"})
    public static String[] BlacklistDimensions = new String[0];
    @Config.Ignore
    public static Set<Integer> blacklistDimensions = null;
    @Config.Comment(value={"List of mod:item:meta,mod:item:meta (meta optional) of mossy blocks and what to convert them into when scraping with knives [note that logs or blocks with positional data are unsuited for this purpose]"})
    public static String[] MossyCobblestones = new String[]{"minecraft:mossy_cobblestone,minecraft:cobblestone", "minecraft:stonebrick:1,minecraft:stonebrick", "minecraft:monster_egg:3,minecraft:monster_egg:2"};
    @Config.Ignore
    private static Map<ItemStack, ItemStack> mossyCobblestones = null;
    @Config.Ignore
    private static BiMap<Block, Block> mossyBlocks = HashBiMap.create();
    @Config.Ignore
    private static BiMap<IBlockState, IBlockState> mossyStates = HashBiMap.create();

    public static Set<Integer> getBlacklistDimensions() {
        if (blacklistDimensions == null) {
            blacklistDimensions = new HashSet<Integer>();
            for (String dim : BlacklistDimensions) {
                blacklistDimensions.add(Integer.parseInt(dim));
            }
        }
        return blacklistDimensions;
    }

    public static Map<ItemStack, ItemStack> getMossyCobblestones() {
        if (mossyCobblestones == null) {
            mossyCobblestones = ConfigUtil.parseMap(new HashMap(), ConfigUtil::parseItemStack, ConfigUtil::parseItemStack, (String)",", (String[])MossyCobblestones);
            mossyBlocks.clear();
            mossyStates.clear();
            for (Map.Entry<ItemStack, ItemStack> entry : mossyCobblestones.entrySet()) {
                ItemStack in = entry.getKey();
                ItemStack out = entry.getValue();
                if (!(in.func_77973_b() instanceof ItemBlock) || !(out.func_77973_b() instanceof ItemBlock)) continue;
                Block blockIn = ((ItemBlock)in.func_77973_b()).func_179223_d();
                Block blockOut = ((ItemBlock)out.func_77973_b()).func_179223_d();
                if (in.func_77960_j() != 0 || out.func_77960_j() != 0) {
                    IBlockState stateIn = blockIn.func_176203_a(in.func_77960_j());
                    IBlockState stateOut = blockOut.func_176203_a(out.func_77960_j());
                    mossyStates.put((Object)stateIn, (Object)stateOut);
                    continue;
                }
                mossyBlocks.put((Object)blockIn, (Object)blockOut);
            }
        }
        return mossyCobblestones;
    }

    @Nullable
    public static IBlockState scrapeResult(IBlockState state) {
        Map<ItemStack, ItemStack> mossy = MossConfig.getMossyCobblestones();
        if (mossyStates.containsKey((Object)state)) {
            return (IBlockState)mossyStates.get((Object)state);
        }
        if (mossyBlocks.containsKey((Object)state.func_177230_c())) {
            return ((Block)mossyBlocks.get((Object)state.func_177230_c())).func_176223_P();
        }
        return null;
    }

    @Nullable
    public static IBlockState mossConversion(IBlockState state) {
        Map<ItemStack, ItemStack> mossy = MossConfig.getMossyCobblestones();
        if (mossyStates.inverse().containsKey((Object)state)) {
            return (IBlockState)mossyStates.inverse().get((Object)state);
        }
        if (mossyBlocks.inverse().containsKey((Object)state.func_177230_c())) {
            return ((Block)mossyBlocks.inverse().get((Object)state.func_177230_c())).func_176223_P();
        }
        return null;
    }
}

