/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.shapes;

import com.google.common.collect.Sets;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.shapes.IShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class RectSolid
implements IShape {
    private final Coord start;
    private final Coord end;

    public RectSolid(Coord start, Coord end) {
        this.start = start;
        this.end = end;
    }

    public static RectSolid newRect(Coord start, Coord end) {
        return new RectSolid(start, end);
    }

    @Override
    public List<Coord> get() {
        ArrayList<Coord> coords = new ArrayList<Coord>();
        for (Coord c : this) {
            coords.add(c);
        }
        return coords;
    }

    @Override
    public Set<Coord> getAnchors() {
        return Sets.newHashSet((Object[])new Coord[]{this.start, this.end});
    }

    @Override
    @Nonnull
    public Iterator<Coord> iterator() {
        return new RectSolidIterator(this.start, this.end);
    }

    private static class RectSolidIterator
    implements Iterator<Coord> {
        Coord cursor;
        Coord start;
        Coord end;

        public RectSolidIterator(Coord start, Coord end) {
            this.start = start.copy();
            this.end = end.copy();
            Coord.correct(this.start, this.end);
            this.cursor = this.start.copy();
        }

        @Override
        public boolean hasNext() {
            return this.cursor.getY() <= this.end.getY();
        }

        @Override
        public Coord next() {
            Coord toReturn = this.cursor.copy();
            if (this.cursor.getZ() == this.end.getZ() && this.cursor.getX() == this.end.getX()) {
                this.cursor = new Coord(this.start.getX(), this.cursor.getY(), this.start.getZ());
                this.cursor.up();
                return toReturn;
            }
            if (this.cursor.getX() == this.end.getX()) {
                this.cursor = new Coord(this.start.getX(), this.cursor.getY(), this.cursor.getZ());
                this.cursor.south();
                return toReturn;
            }
            this.cursor.east();
            return toReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

